%Code written by Namrata Vaswani
%If you use this code, please cite: N. Vaswani, Kalman Filtered Compressed Sensing, ICIP 2008

%Simulating the system explained in the above paper 
%(start with S-2 nonzero elements, add 2 elements at t=5)

%main file: runsims2.m calls all other files
%simulate data: gendata
%KF-CS: cskf_auto_T1unknown
%KF-CS (initial nonzero set unknown): cskf_auto2
%regular CS (Dantzig Selector): regularcs : usually larger errors than regularcs_no_noise
%regular CS (thresholds no noise case): regularcs_no_noise
%Genie-aided KF: geniekf
%Full KF: fullkf

%To run the code: runsims2, followed by plotting the various errors

%tot: total time
%S: S_{max}

randn('state',0); rand('state',0); disp('random state 0 on')

%set parameters
global n
global m
global tot
global lambdap
global S

tot = 10;
m = 256;    n = 72;     S =  16 %8 16 25; % round( n/log2(m/n) )
cc = 1; %10 %multiply 'sigma' and 'a' by 'cc'
sigma0 =  cc* (1/3)*sqrt(S/n)
sigsys = 1;
siginit = 3;
lambdap = 4 %beta = 2; lambdap = sqrt( (1+beta)*2*log2(m) ); prob_lb = 1 - 1/( sqrt(pi*log2(m))*m^beta )

S1 = S - 2;
t2 = 5;

Agen = (1/sqrt(n)) * randn(n,m);
A = zeros(size(Agen));
for col = 1:m
    A(:,col) = Agen(:,col)/norm( Agen(:,col) );
end
R = (sigma0^2)*eye(n);
Q = (sigsys^2)*eye(m); %F = eye(m);
Pi0 = (siginit^2)*eye(m);

run_only_kfcs = 0
for ct = 1 : 100
    gendata
    [x_upd] = geniekf(y,Pi0,A,Q,R,T1,T2,t2);
    for t = 1:tot
        err_genie(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
    end

    [x_upd,T_hat,x1_upd] = cskf_auto_T1unknown(y,Pi0,A,Q,R);
    for t = 1:tot
        err(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
        energy(ct,t) = norm( x(:,t) )^2;
    end
    not_detected(ct) = length(setdiff(T,T_hat))

    if run_only_kfcs==0
        [x_upd] = fullkf(y,Pi0,A,Q,R);    %,T1,T2);
        for t = 1:tot
            err_full(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
        end

        [x_upd,T_hat] = regularcs_no_noise(y,Pi0,A,Q,R); %[x_upd] = regularcs(y,Pi0,A,Q,R);
        for t = 1:tot
            err_regularcs_nonoise(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
        end
        not_detected_regularcs_nonoise(ct) = length(setdiff(T,T_hat))


        [x_upd,T_hat] = regularcs(y,Pi0,A,Q,R); %[x_upd] = regularcs(y,Pi0,A,Q,R);
        for t = 1:tot
            err_regularcs(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
        end
        not_detected_regularcs(ct) = length(setdiff(T,T_hat))


        [x_upd,T_hat,x1_upd] = cskf_auto2(y,Pi0,A,Q,R,T1);
        for t = 1:tot
            err_T1known(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
        end
        not_detected_T1known(ct) = length(setdiff(T,T_hat));
    end
    %disp(T')

    disp(ct)
end