function [gammaopt,lambdaopt,Bk]=gamma_star(A,T,Delta,w,y,x,mu_hat,lambdaset)
t=length(T);
Bk=inf;
for i=1:1:length(lambdaset)
    lambda=lambdaset(i);
    
    for k=0:1:length(Delta)
        if(k==0)
            Delta_tilde=[];
        else
            Delta_tilde=largestk(x,Delta,k);
        end
        [Q_T_lambda_Delta_tilde,M_T_lambda_Delta_tilde,P_T_lambda_Delta_tilde,ERC_T_lambda_Delta_tilde,c_T_lambda_Delta_tilde]=QMPERCc(A,T,Delta_tilde,y,lambda,mu_hat);
        if(ERC_T_lambda_Delta_tilde<=0||rank(Q_T_lambda_Delta_tilde)<t+k&&lambda>0)%
            continue;
        end
        [gamma_T_lambda,g]=gamma_T_lambda_f(A,T,Delta,Delta_tilde,w,y,x,mu_hat,lambda,Q_T_lambda_Delta_tilde,P_T_lambda_Delta_tilde,ERC_T_lambda_Delta_tilde,c_T_lambda_Delta_tilde);
        if(g<Bk)
            Bk=g;
            gammaopt=gamma_T_lambda;
            lambdaopt=lambda;
        end
    end
end

function [Delta_tilde]=largestk(x,Delta,k)
m=length(x);
tx=zeros(m,2);
tx(Delta,1)=abs(x(Delta));
tx(:,2)=1:m;
txsorted=sortrows(tx,-1);
Delta_tilde=txsorted(1:k,2);



function [gamma_T_lambda,g]=gamma_T_lambda_f(A,T,Delta,Delta_tilde,w,y,x,mu_hat,lambda,Q_T_lambda_Delta_tilde,P_T_lambda_Delta_tilde,ERC_T_lambda_Delta_tilde,c_T_lambda_Delta_tilde)
%[Q_T_lambda_Delta,M_T_lambda_Delta,P_T_lambda_Delta,ERC_T_lambda_Delta,c_T_lambda_Delta]=QMPERCc(A,T,Delta,y,lambda,mu_hat);
%[Q_T_lambda_Delta_tilde,M_T_lambda_Delta_tilde,P_T_lambda_Delta_tilde,ERC_T_lambda_Delta_tilde,c_T_lambda_Delta_tilde]=QMPERCc(A,T,Delta_tilde,y,lambda,mu_hat);
t=length(T);
[n,m]=size(A);
d_tilde=length(Delta_tilde);
T_Delta_tilde=union(T,Delta_tilde);
f1=sqrt(norm((A(:,T)'*A(:,T)+lambda*eye(t))\A(:,T)'*A(:,Delta_tilde)*P_T_lambda_Delta_tilde)^2+norm(P_T_lambda_Delta_tilde)^2);
f2=norm(inv(Q_T_lambda_Delta_tilde));
f3=norm((Q_T_lambda_Delta_tilde)\A(:,T_Delta_tilde)');
f4=sqrt(norm((Q_T_lambda_Delta_tilde)\A(:,T_Delta_tilde)'*A(:,setdiff(Delta,Delta_tilde)))^2+1);
maxcor=max(sum(abs(A(:,union(T,Delta))'*A(:,setdiff(1:m,T_Delta_tilde))).^2));

g1=lambda*f2*(sqrt(d_tilde)*f1*maxcor/ERC_T_lambda_Delta_tilde+1);
g2=sqrt(d_tilde)*f1*f3*maxcor/ERC_T_lambda_Delta_tilde+f3;
g3=sqrt(d_tilde)*f1*f4*maxcor/ERC_T_lambda_Delta_tilde+f4;
g4=sqrt(d_tilde)*norm(A(:,setdiff(1:m,T_Delta_tilde))'*w,inf)*f1/ERC_T_lambda_Delta_tilde;
g=g1*norm(x(T)-mu_hat(T))+g2*norm(w)+g3*norm(x(setdiff(Delta,Delta_tilde)))+g4;


gamma_T_lambda=norm(A(:,setdiff(1:m,union(T,Delta_tilde)))'*(y-A*c_T_lambda_Delta_tilde),inf)/ERC_T_lambda_Delta_tilde;


function [Q_T_lambda,M_T_lambda,P_T_lambda,ERC_T_lambda,c_T_lambda]=QMPERCc(A,T,S,y,lambda,mu_hat)
[n,m]=size(A);
t=length(T);
M_T_lambda=eye(n)-A(:,T)*((A(:,T)'*A(:,T)+lambda*eye(t))\A(:,T)');
T_S=union(T,S);
t=length(T);
s=length(S);
Q_T_lambda=A(:,T_S)'*A(:,T_S)+lambda*[eye(t) zeros(t,s);zeros(s,t+s)];
P_T_lambda=inv(A(:,S)'*M_T_lambda*A(:,S));
ERC_T_lambda=1-max(sum(abs(P_T_lambda*A(:,S)'*M_T_lambda*A(:,setdiff(1:m,T_S)))));
c_T_lambda=zeros(m,1);
c_T_lambda(T_S)=(Q_T_lambda)\(A(:,T_S)'*y+lambda*[mu_hat(T);zeros(s,1)]);



