
% Demonstration of the CSKF-p from the paper
% 'Methods for Sparse Signal Recovery Using Kalman Filtering with Embedded
% Pseudo-Measurement Norms and Quasi-Norms' by A. Carmi, P. Gurfil and D.
% Kanevsky. 
% IEEE TRANSACTIONS ON SIGNAL PROCESSING, VOL. 58, NO. 4, APRIL 2010


n_iterations=500; %1000;   % Number of CSKF PM iterations


n=100; %1000; %256;   % signal dimension
nnz=20; %30;  % number of nonzero entries
m=50; %500;    % number observations


% Produce a Gaussian RIP matrix

xa=mvnrnd(zeros(1,n),1/m*eye(n),m);

for i=1:n,
    xa(:,i)=xa(:,i)/norm(xa(:,i));
end


% Construct the actual signal

beta=zeros(n,1);

mm=round(unifrnd(1,n,nnz,1));


for i=1:nnz,
    beta(mm(i))=unifrnd(-1,1);
end



% CSKF initial state

disp(sprintf('running cskf....'));

Pk0=eye(n)*1e2;
beta_k=zeros(n,1);
beta_kp=beta_k;


R=1e-2^2*eye(m);   % Measurement noise covariance
Re_1=600^2;          % CSKF-1 PM tuning parameter (sigma)
Re_p=1000^2;         % CSKF-p PM tuning parameter (l_p norm variant)

p=0.7;               % Psuedo-norm l_p


n1=mvnrnd(zeros(1,m),R);

xb=xa*beta+n1';    % Noisy observation vector

% Run the CSKF-1 to recover the signal from the underdetermined system

tic
[beta_k, Pk]=CSKF(beta_k, Pk0, xb, xa, R, Re_1, n_iterations);
t_cskf1=toc;

disp(norm(beta-beta_k)^2);

% Compute the ideal normalized estimation error

ds=0;

for jj=1:n,
    ds=ds+min(beta(jj)^2,R(1,1));
end


ek=sqrt(norm(beta-beta_k)^2/ds);
ekp=sqrt(norm(beta-beta_kp)^2/ds);

disp(sprintf('CSKF-1 Ideal normalized recovery error  %2.2f   (running time %2.2f sec)\n', ek, t_cskf1));

figure(1);
hold on
plot(beta);
plot(beta_k,'rs');
legend('Actual','CSKF-1');







