
% Demonstration of the CSKF-p from the paper
% 'Methods for Sparse Signal Recovery Using Kalman Filtering with Embedded
% Pseudo-Measurement Norms and Quasi-Norms' by A. Carmi, P. Gurfil and D.
% Kanevsky. 
% IEEE TRANSACTIONS ON SIGNAL PROCESSING, VOL. 58, NO. 4, APRIL 2010

clc;
clear all;

addpath ../Justin_Zienl/DCS_AMP_v1_0/new_modCs_code
addpath ../mainfile

T = 40;
mse_t = zeros(1,T);
mse_mod_t = zeros(1,T);%SNR = input('SNR:');
max_iter = input('max_iter ;');
for iter = 1:max_iter
    
    
    n_iterations=100; %1000;   % Number of CSKF PM iterations
    n=256; %1000; %256;   % signal dimension
    nnz=10; %30;  % number of nonzero entries
    m=72; %500;    % number observations
    
    % Produce a Gaussian RIP matrix
    
    xa=mvnrnd(zeros(1,n),1/m*eye(n),m);
    
    for i=1:n,
        xa(:,i)=xa(:,i)/norm(xa(:,i));
    end


    % Construct the actual signal
    
    beta=zeros(n,1);
    mm=round(unifrnd(1,n,nnz,1));
    for i=1:nnz,
        beta(mm(i))=unifrnd(-10,10);
    end
    x_sig = zeros(n,T);
    x_sig(:,1) = beta;
    for t=2:T
        x_sig(:,t) = beta;   %%% static case
    end,
    total_sig_energy = 0;
    for t=1:T
        total_sig_energy = total_sig_energy + norm(x_sig(:,t))^2;
    end,
    sig_energy = total_sig_energy/T;
    
   
    sig2e = 1e-2^2;
    
    % CSKF initial state
    
    disp(sprintf('running cskf....'));
    Pk0=eye(n)*1e2;
    beta_k=zeros(n,1);
    beta_kp=beta_k;
    
    R=sig2e*eye(m);   % Measurement noise covariance
    Re_1=200^2;          % CSKF-1 PM tuning parameter (sigma)
    Re_p=20000^2;         % CSKF-p PM tuning parameter (l_p norm variant)
    p=0.5;               % Psuedo-norm l_p
    
    for t=1:T
        n1=mvnrnd(zeros(1,m),R);
        xb(:,t)=xa*beta+n1';    % Noisy observation vector
    end,
    
    %% static encoding is done in the above 
    
    % Run the CSKF-1 to recover the signal from the underdetermined system
    Q = zeros(n,n); 
    
    t_cskf1 = 0;
    Pk = Pk0;
    for t=1:T
       
         
        [beta_k, Pk]=CSKF_p(beta_k, Pk, xb(:,t), xa, R, Re_p, n_iterations,p);  %%%  Algorithm CSKF-p is executing
        Pk = Pk + Q;
        
        % Compute the ideal normalized estimation error
        ds=0;
        for jj=1:n,
            ds=ds+min(beta(jj)^2,R(1,1));
        end
        
        ek=sqrt(norm(beta-beta_k)^2/ds);
        ekp=sqrt(norm(beta-beta_kp)^2/ds);
        disp(sprintf('CSKF-1 Ideal normalized recovery error  %2.2f   ', ek));
        
        % figure(1);
        % hold on
        % plot(beta);
        % plot(beta_k,'rs');
        % legend('Actual','CSKF-1');
        
        mse(t) = norm(beta-beta_k)^2;
        %disp(nmse);
    end,
    mse_t = mse_t + mse;
    disp(sprintf('(running time %2.2f sec)\n ',t_cskf1));
    
    %%% For KF_modCS
    
    for t=1:T
        x_true{t} = x_sig(:,t);
        y{t} = xb(:,t);    
    end,
    A = xa;
   % sig2e = sig2e;
    tic;
   % [x_mod] = KF_ModCS_animeshThresh_withoutInfo_signal_model_Asif(n,m,A,T,x_true,y,sig2e);
   
       [fixed_value_initial] = fixing_singular_value(x_true{1},A,m);
        singular_value_low = fixed_value_initial-0.4; singular_value_high = singular_value_low + 0.5 ;
        C1 = 1.2 - fixed_value_initial; C2 = C1; 
     
        
        [nmse_mod] = KF_ModCS_withoutInfo_signal_model_2(n,m,A,T,x_true,y,sig2e,fixed_value_initial,singular_value_low,singular_value_high,C1,C2);
        mse_mod = 10.^(nmse_mod./10)*norm(beta)^2;
    t_mod = toc;
    
    mse_mod_t = mse_mod_t + mse_mod;
end,

mse_t = mse_t/iter;
mse_mod_t = mse_mod_t/iter;

string1 = strcat(datestr(clock,30),'avishy_comparison','.mat');
save(string1,'mse_t','mse_mod_t');




