function[er] = KF_ModCS_decoding_with_information_simple_algo(m,n,A,tot,x,y,sig2e,sigma2,alpha,beta)

if alpha == 0
    rho = sigma2/(beta^2);
else
    rho = (2-alpha)*alpha*sigma2/(beta^2) ; 
end,

eps = sqrt(3*n*sig2e);
R = sig2e*eye(n);
t=1;
x0 = zeros(m,1);
[x_cs] = doing_only_residual_cs(A,x0,y{t},m,eps);
if sum(abs(x_cs))==0
     eps = sqrt(n*sig2e);
    [x_cs] = doing_only_residual_cs(A,x0,y{t},m,eps);
end,

singular_value = 0.2; singular_value_high = 0.8; T_in = []; th_add1 = 0.2*sigma2; mean_th = sigma2; th_max = 10*mean_th; 
[T_hat,th_add1] = get_addition_5_threshold_without_inf_real_image(A,x_cs,singular_value,singular_value_high,T_in,th_add1,mean_th,th_max);



T_mod = T_hat;
th_mod = th_add1;

S_hat = length(T_hat);

Pi0 = zeros(m,m);
Pi0(T_hat,T_hat) = sigma2*eye(S_hat); 

%Q = rho.*eye(m);
x1_upd = zeros(S_hat,tot);
x_upd = zeros(m,tot);

A1 = A(:,T_hat);
%Q1 = Q(T_hat,T_hat);

P_pred = Pi0(T_hat,T_hat);
x1p = zeros(S_hat,1);  %x1_pred(:,t)= x1p;
K = P_pred*A1'*inv(R + A1*P_pred*A1');
P_upd  = ( eye(S_hat) - K*A1 )*P_pred;
x1_upd(:,t) = x1p + K*(y{t} - A1*x1p);
x_upd(T_hat,t) = x1_upd(:,t);

%%% deletion threshold
x_min = min(abs(x1_upd(:,t)));
th_del1 = x_min;

N_t = find(abs(x{t})>0);
sup_add_err(t) = length(setdiff(N_t,T_hat))/length(N_t);
sup_del_err(t) = length(setdiff(T_hat,N_t))/length(N_t);

for t=2:tot
    
    %%% apply kf-modcs to estimate the variance and 
    x_tmp = x_cs(T_hat);
    
    eps = sqrt(3*n*sig2e);
    [x_mod1] = doing_only_residual_modcs(A,x0,y{t},T_mod,m,eps);
    if sum(abs(x_mod1))==0
         eps = sqrt(n*sig2e);
        [x_mod1] = doing_only_residual_modcs(A,x0,y{t},T_mod,m,eps);
    end,
    
    x_mod_tmp = x_mod1(T_hat);
    %ratio = mean(x_tmp'*x_mod_tmp)/mean(x_tmp'*x_tmp);
    %alpha = 1 - ratio;
    
    Q1 = rho.*eye(S_hat);
    
    % temp kalman filter to get the residue 
    P_pred_temp =(1-alpha)^2*P_upd + beta^2*Q1;
    x1p_temp = (1-alpha)*x1_upd(1:S_hat,t-1) ;
    K_temp = P_pred_temp*A1'*inv(R + A1*P_pred_temp*A1');
    x1_upd_temp = x1p_temp + K_temp*(y{t}-A1*x1p_temp);
    x_upd_temp = zeros(m,1);
    x_upd_temp(T_hat) = x1_upd_temp;
    
    eps = sqrt(3*n*sig2e);
    [x_cs] = doing_only_residual_modcs(A,x_upd_temp,y{t},T_mod,m,eps);
    if sum(abs(x_cs)==0)
        eps = sqrt(n*sig2e);
        [x_cs] = doing_only_residual_modcs(A,x_upd_temp,y{t},T_mod,m,eps);
    end,
    
    singular_value = 0.4;
    [T_mod,th_mod] = get_addition_5_threshold_without_inf_real_image(A,x_cs,singular_value,singular_value_high,T_in,th_mod,mean_th,th_max);
    singular_value = 0.2;
    [r_hat,th_add1] = get_addition_5_threshold_without_inf_real_image(A,x_cs,singular_value,singular_value_high,T_hat,th_add1,mean_th,th_max);
    
   
    Tdiff_hat = setdiff(r_hat,T_hat); Sdiff_hat = length(Tdiff_hat);
    
    if Sdiff_hat==0
    
        P_pred = (1-alpha)^2*P_upd + beta^2*Q1;
        x1p = (1-alpha)*x1_upd(1:S_hat,t-1);  %x1_pred(:,t)= x1p;
        K = P_pred*A1'*inv(R + A1*P_pred*A1');
        P_upd  = ( eye(S_hat) - K*A1 )*P_pred;
        x1_upd(1:S_hat,t) = x1p + K*(y{t} - A1*x1p);
    else
        x1p = (1-alpha)*x1_upd(1:S_hat,t-1) ;
        P_tmp =zeros(m,m);
        P_tmp(T_hat,T_hat) = (1-alpha)^2*P_upd + beta^2*Q1;
%         u_diff = x_cs(Tdiff_hat);
%         mean_u_diff = mean(u_diff);
%         var_u_diff = var(u_diff);
        for j=1:Sdiff_hat
                      
            P_tmp(Tdiff_hat(j),Tdiff_hat(j))= sigma2 ;
        end,
        P_pred_new = P_tmp(r_hat,r_hat);
        x_tmp = zeros(m,1);x_tmp(T_hat) = x1p; %x_tmp(Tdiff_hat) = mean_x;
        x1p_new = x_tmp(r_hat);        
        T_hat = r_hat;        S_hat = length(T_hat);
        A1 = A(:,T_hat);
        %Q1 = Q(T_hat,T_hat);
        P_pred = P_pred_new;
        x1p = x1p_new;
        K = P_pred*A1'*inv(R + A1*P_pred*A1');
        P_upd  = ( eye(S_hat) - K*A1 )*P_pred;
        x1_upd(1:S_hat,t) = x1p + K*(y{t} - A1*x1p);       
    end
    x_upd(T_hat,t) = x1_upd(1:S_hat,t);
    delta_del2 =[];
    for j=1:S_hat
        if abs(x_upd(T_hat(j),t))<th_del1
            delta_del2 = [delta_del2 T_hat(j)];
        end,
    end,
    delta_del2 = delta_del2';
    delta = delta_del2;
    Sdiff_hat1 = length(delta);
    r_hat = setdiff(T_hat,delta);
    if Sdiff_hat1>0      
        x1p =(1-alpha)*x1_upd(1:S_hat,t-1);
        %P_pred = P_upd + Q1;
        P_tmp = zeros(m,m);
        P_tmp(T_hat,T_hat) = P_pred;
        P_pred_new = P_tmp(r_hat,r_hat);
        x_tmp = zeros(m,1);x_tmp(T_hat) = x1p;
        x1p_new = x_tmp(r_hat);
        T_hat = r_hat;        S_hat = length(T_hat);  
        A1 = A(:,T_hat);
     %   Q1 = Q(T_hat,T_hat);
        P_pred = P_pred_new;
        x1p = x1p_new;
        K = P_pred*A1'*inv(R + A1*P_pred*A1');
        P_upd  = ( eye(S_hat) - K*A1 )*P_pred;
        x1_upd(1:S_hat,t) = x1p + K*(y{t} - A1*x1p);
     end
    x_upd(T_hat,t) = x1_upd(1:S_hat,t); 
    
    index_set = find(abs(x1_upd(1:S_hat,t)~=0));
    value_set = abs(x1_upd(index_set,t));
     x_min = min(value_set);
    th_del1 = min(th_add1,((t-1)*th_del1 + x_min)/t) ;   
    
    
    N_t = find(abs(x{t})>0);
    sup_add_err(t) = length(setdiff(N_t,T_hat))/length(N_t);
    sup_del_err(t) = length(setdiff(T_hat,N_t))/length(N_t);
    if t==tot
        display('Kf_CS__with_nonZero_initialX_bounded_noise');
    end,
end,
for t=1:tot
    er(t) = 10*log10(norm(x{t}-x_upd(:,t))^2/norm(x{t})^2);
end,