 #ifndef _TESTAPS_H
 #define _TESTAPS_H

#include <Timer.h>
#include "../APS/APS.h"

#define  INTERVAL_NUM (sizeof(eventInterval) / sizeof(uint16_t))

//#define GRANDPA 1

enum {
	AM_RADIO_MSG = 6,
	AM_SERIAL_MSG = 9,
	SYNC_OFFSET = 3000,						//sync
	TEST_COLLECTION_ID	= 0xEE,
	ROOT_NODE_ID = 15,
	MAX_LATENCY	= 1500,			
	SEND_PKT_NUM = 50,			//100 -> 10 -> 20->50
//	MAX_ELEMENT_NUM = 8,			//12 - > 8
	INVALID_TX_COUNT = 0xFF,
	BROADCAST_TIMES = 100,		
	BROADCAST_INTERVAL = 20,
	LOG_HEADER_LEN = 23,			//16->18 -> 22 w/o child id
	ROUND_TIMER_PERIOD = 1000,
	ROUND_TIMER_COUNT = 120,
//	MAX_INTERVAL = 15000,	//max event interval 9.8 s
//	INTERVAL_NUM = 48,
};

  typedef nx_struct testMsg {
    nx_uint8_t source_id;
	nx_uint8_t seqNum;				//to be reset at the beginning of each experiment
	nx_uint32_t generatedTime;
  } testMsg;

  typedef nx_struct logMsg {
	//local info
	nx_uint8_t my_node_id;
	nx_uint8_t parent_id;
	nx_uint16_t myETX;
	nx_uint16_t myLinkETX;	
	nx_uint8_t myHopLen;
	nx_uint8_t txORrx;
	nx_uint8_t thisTxCount;
	nx_uint32_t actionTimestamp;

	//injection info
	nx_uint8_t topology;
	nx_uint8_t protocol;
	nx_uint8_t traffic;
	nx_uint8_t latencyReq;
	nx_uint8_t reptID;

	nx_uint16_t myETT;
	nx_uint16_t myLinkETT;
	nx_uint8_t child_id;
	
	//received / intercepted pkt info
//	testMsg elements[MAX_ELEMENT_NUM];
	nx_uint8_t data[TOSH_DATA_LENGTH - LOG_HEADER_LEN];
  } logMsg;

   typedef nx_struct RadioCmdMsg {
	nx_uint8_t 	iSeqNum;				//sequence # for sync
	nx_uint8_t topology;
	nx_uint8_t protocol;
	nx_uint8_t traffic;
	nx_uint8_t latencyReq;
	nx_uint8_t reptID;
//	nx_uint8_t ExperimentID;
  } RadioCmdMsg;


#endif