/*
 * Header for application-driven packet scheduling (APS)
 *
 * @author: Hongwei zhang
 *                 zhangho@cse.ohio-state.edu
 *
 * @modified: July 29, 2005
 */


#include <message.h>

#ifndef _APS_H 
#define _APS_H 


//#ifndef _APS_cnst_H
//#define _APS_cnst_H  

//#define SIMPLE_PACKING 1
//#define NO_PACKING_AT_ALL 1                      
//#define SL_PACKING 1
#define SCHEDULE_PACKING 1                        

//#define TWOHOP 1

#define EXPT_ONLY  1         //to comment out when running real experiments

//#define DEBUG_APS_ONLY 1 //to comment out when running real experiments

//#endif

//#define ROUTE_INVALID 0xFF
//#define TIME_INVALID 0xFFFF

#define	TIME_INVALID 0xFFFFFFFF
#define	 HOPCOUNT_INVALID  0xFFFF			//xh
#define	ROUTE_INVALID  0xFFFF	//xh

/* constants */
enum {
  //contract for upper layer
  MIN_PAYLOAD_ELEMENT_LEN = 6, //12 a payload element is regarded as invalid, if its length is less than this number;
                                                                              //including PE_OVERHEAD
							
  //(parameter) estimation
  DEFAULT_MAX_PKT_INTERVAL = 180000,                    //milliseconds;  
                                                                                      

  MIN_PKT_SIZE = MIN_PAYLOAD_ELEMENT_LEN,                                            //bytes

 // TICKS_PER_MILLISECOND = 32,                  //modified TOSSIM SysTimeC and msp430 TimerC: simulating 32KHz clock

  compPastW = 3,                                                       //7/8 weight factor

  //queuing
  QUEUE_SIZE = 23,                                              //packet queue size
  WAITING_BUFFERS_THRESHOLD = (QUEUE_SIZE/3),   //max. number of busy buffers simultaneously waiting to be packed

 
  APS_TIMER_INTERVAL = 100,                            //milliseconds
  

  //miscl.
//  MintRoute_BEACON_INTERVAL = 20,          //seconds
 // ETT_SCALE_FACTOR = 2,                            //getETT(0) is the actual ETT(0) << ETT_SCALE_FACTOR
//  TRANSMIT_POWER = 31,                             //max. power

  //self-stabilization
  MAX_PKT_TIME_DEVIATION_RATIO = 10, // the estimated per-pkt-transmission-time

  APS_BASE_STATION_ID = 0, 
  AM_APS_PKT = 220,
  
  //REQUIRED LATENCY
//	REQ_LATENCY = 0,     //application setting
//#ifndef TOSSIM
  //TOSH_DATA_LENGTH
 //TOSH_DATA_LENGTH =110,
//#endif
 };


/* -------------------------------------------------------*
 *                            data structures                            *
 *-------------------------------------------------------*/
#define TOSH_DATA_LENGTH  110

	#define ALR_OVERHEAD      19


#define PAYLOAD_OVERHEAD  1
#define PE_OVERHEAD 6
//#define TIME_TILL_FIRES  1000
#ifdef EXPT_ONLY
#define MAX_APS_PAYLOAD_LEN (TOSH_DATA_LENGTH - 25)  //WARNING: must be greater than ALR_OVERHEAD
#else
#define MAX_APS_PAYLOAD_LEN (TOSH_DATA_LENGTH - ALR_OVERHEAD)
#endif

#define MAX_APS_PE_LEN (MAX_APS_PAYLOAD_LEN - PAYLOAD_OVERHEAD)

#define C_0 (MAX_APS_PAYLOAD_LEN * MAX_APS_PAYLOAD_LEN)  //for digital computation

/* Format of each payload element */
typedef struct APSPayloadElement {
  uint8_t length;                 //length of this payload element
  uint8_t type;                     //AM packet type
  uint16_t maxLatency;       //maximum latency allowed for this payload element: HAS TO BE EVEN NUMBER  
  uint16_t SLatency;         //SL-PACKING	
  uint8_t data[MAX_APS_PE_LEN - PE_OVERHEAD];
} TOS_APSPE;

/* Format of payload structure in an APS packet */
typedef struct APSPayload {
  uint8_t length;                                                      //overall length, in # of bytes, of all the existing payload
                                                                                   //elements of the packet, not including PAYLOAD_OVERHEAD;
  //uint8_t minElementLen;                                   //length of the shortest element in the packet

  //uint8_t maxLatency;                                            //max of the maxLatency of all the payload elements

  uint8_t data[MAX_APS_PAYLOAD_LEN - PAYLOAD_OVERHEAD];   //the payload consists a sequence 
                                                                                        //of payload elements of varying length
} TOS_APSPayload;

/* An element of the packet queue, which is organized as doubly-linked lists */
typedef struct APSQueueElement {
  uint8_t length;                         //overall payload length of the packet; NOT including ALR overhead
  uint16_t maxLatency;            //min. maxLatency of all the payload elements
  uint16_t SLatency;         //SL-PACKING	  
  message_t msg;             //the packet
  uint8_t prev;        //pointer to the previous element: = QUEUE_SIZE if it is the first element in a list
  uint8_t next;        //pointer to the next element:  = QUEUE_SIZE if it is the last element in a list
} APSQElement;


/****  statistics ****/
typedef struct APSStats {
  uint32_t numReceptions; 
  uint32_t numQueueOverflows;
} TOS_APS_Stats; 


/**** functions ****/
bool queueSanity();

#endif
