/**
 * Copyright (c) 2004 - The Ohio State University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL THE OHIO STATE UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE OHIO STATE
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE OHIO STATE UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE OHIO STATE UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */


//-----  [START] -----
//
//MODULE:                                             TestReliableComm.nc
//KEY WORDS DESCRIPTION:       configuration file for TestReliableComm
//FUNCTIONAL DESCRIPTION:    test file for ReliableComm
//AUTHOR:                                             Hongwei Zhang
//AUTHOR CONTACT INFO:          zhangho@cse.ohio-state.edu
//LICENSING:                                         non-profit use only
//
//-----  [END] -----


includes AM;
includes ReliableComm;

#ifndef TEST_HANDLER_ID
#define TEST_HANDLER_ID 85
#endif

configuration TestReliableComm{
}

implementation {
  components Main, TestReliableCommM, ReliableCommC, //"to use ReliableComm for UART communication": GenericComm as Comm, 
                          TimerC, LedsC as Leds;

  Main.StdControl -> TestReliableCommM.StdControl;
  Main.StdControl -> TimerC.StdControl;

  TestReliableCommM.SubControl -> ReliableCommC.StdControl;
  //TestReliableCommM.SubControl2 -> Comm.Control;

  TestReliableCommM.ReliableCommControl -> ReliableCommC;
  TestReliableCommM.ReliableSend -> ReliableCommC.ReliableSendMsg[TEST_HANDLER_ID];
  TestReliableCommM.ReliableReceive -> ReliableCommC.ReliableReceiveMsg[TEST_HANDLER_ID]; 

  //TestReliableCommM.SendMsg -> Comm.SendMsg[TEST_HANDLER_ID+1];

  TestReliableCommM.Timer -> TimerC.Timer[unique("Timer")];
  TestReliableCommM.Leds -> Leds;
  
}
