
/**
 * Copyright (c) 2006 - Wayne State University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL THE WAYNE STATE UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE WAYNE STATE
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE WAYNE STATE UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE WAYNE STATE UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

/*@author Hongwei Zhang, Anish Arora
*/

//-----------------------------------------------//
#define LOF_ROUTING 1
//#define MINT_ROUTING 1
//#define GRID_ROUTING 1

//#define LOCAL_DEBUG 1  //for debugging with local motes/stargates 
#ifndef LOCAL_DEBUG
#define TSYCH 1
//#define TOSSIM 1 
#endif
//-----------------------------------------------//

includes global;
includes TestRouting;
includes LOF;

#ifndef UART_RCV_Handler
#define UART_RCV_Handler 99
#define UART_SEND_Handler 100
#endif

#ifndef AM_APP_DATA_CHANNEL
#define AM_APP_DATA_CHANNEL 88
#endif


configuration TestRouting {
}
implementation {
  components Main, TestRoutingM, 
#ifdef LOF_ROUTING   
    LOFC,
#endif
#ifdef MINT_ROUTING
    WMEWMAMultiHopRouter,
#endif
#ifdef GRID_ROUTING
    GridRouting,
    GridTree,
#endif
    QueuedSend,
#ifndef TOSSIM
#ifdef TSYCH
    TsyncC,
#endif    
#endif
    GenericComm as Comm,
    TimerC, 
    RandomC, //RandomLFSR,
    //LedsC as Leds;
    NoLeds as Leds;

  Main.StdControl -> TestRoutingM;

#ifdef LOF_ROUTING  
  TestRoutingM.RoutingControl -> LOFC.StdControl; //slf
  TestRoutingM.Routing -> LOFC;
#endif

#ifdef MINT_ROUTING	
  TestRoutingM.RoutingControl-> WMEWMAMultiHopRouter.StdControl;	
  TestRoutingM.Send -> WMEWMAMultiHopRouter.Send[AM_APP_DATA_CHANNEL];  
  TestRoutingM.Intercept -> WMEWMAMultiHopRouter.Intercept[AM_APP_DATA_CHANNEL]; 	
  TestRoutingM.RouteControl -> WMEWMAMultiHopRouter; 
  WMEWMAMultiHopRouter.ReceiveMsg[AM_APP_DATA_CHANNEL]-> Comm.ReceiveMsg[AM_APP_DATA_CHANNEL];
#endif

#ifdef GRID_ROUTING
  TestRoutingM.RoutingControl -> GridTree.StdControl;
  TestRoutingM.RoutingControl -> GridRouting.StdControl;
  TestRoutingM.Routing -> GridRouting;
  GridRouting.GridInfo -> GridTree.GridInfo;
#endif

  TestRoutingM.QueuedSendControl->QueuedSend;
  TestRoutingM.QueueControl->QueuedSend;
  TestRoutingM.UARTQueuedSend -> QueuedSend.SendMsg[UART_SEND_Handler+1];

  TestRoutingM.UARTReceive -> Comm.ReceiveMsg[UART_RCV_Handler];
  TestRoutingM.UARTSend -> Comm.SendMsg[UART_SEND_Handler];

#if !defined(TOSSIM) && defined(TSYCH)
  TestRoutingM.TimeSyncControl -> TsyncC.StdControl;
  TestRoutingM.Time -> TsyncC;
#endif

  TestRoutingM.TimerControl -> TimerC.StdControl;
  TestRoutingM.Timer -> TimerC.Timer[unique("Timer")];

  TestRoutingM.Random32 -> RandomC;//LFSR;

  TestRoutingM.Leds -> Leds;
}
