
#ifndef TESTROUTING_H
#define TESTROUTING_H 1

#include "QueuedSend.h" 

//#define INJECT_TRAFFIC_PATTERN 1  //completely use Injector to control traffic trace

#define DEFAULT_NUM_EXPTS_PER_PARAMETER_SET 40 
#define MAX_TRANSMIT_COUNT 8

#define START_LATENCY 20000 //20 seconds in units of milliseconds
#define EXPT_INTERVAL 90000//180000 //1.5 or 3 minutes in milliseconds

#define NUM_PKTS_PER_EVENT_PER_NODE 2

#define TOTAL_NUM_OF_SENDERS 48

//-----------------------------------------------------------------------------------//
#define NUM_POWER_LEVELS 4 
#define NUM_MAX_TRANSMIT_COUNTS 3 
#define STARTING_POWER_PTR 0 
#define FINISHING_POWER_PTR (NUM_POWER_LEVELS-1) 
#define STARTING_MT_PTR 0 
#define FINISHING_MT_PTR (NUM_MAX_TRANSMIT_COUNTS-1) 

#define BASE_SET_SNOOPING_LATENCY 4000 //5  minutes after not receiving (9, 3)-parameter packets 
//#define BASE_SET_SNOOPING_LATENCY 300000 //5  minutes after not receiving (9, 3)-parameter packets 

#define TIMER_INTERVAL 128 //milliseconds

#define PENDING_DEAD_THRESHOLD 3000 //3 seconds 

#ifndef NULL32
#define NULL32 ((uint32_t)0xffffffff)
#define NULL16 ((uint16_t)0xffff)
#define BASE_ID 0
#endif


typedef struct AppMsg{ //11 bytes
  uint8_t src;
  uint16_t seq; //sequence number
  uint8_t type;
  uint32_t sendingTime;
  uint8_t exptId;
  uint8_t powerLevel;
  uint8_t maxTransmitCount;
}PACKED AppMsg;


/*for log*/
typedef struct ReportedMsg{
  uint8_t flag; /*1: send log 0: recv log*/
  uint8_t src;
  uint16_t seq; //sequence number
  uint8_t type;
  uint32_t sendingTime;
  uint8_t exptId;
  uint8_t powerLevel;
  uint8_t maxTransmitCount;  
    
  //per hop
  uint8_t dst;  
  uint32_t receptionTime; /*it refers to senddone time if flag=1, and receive time if flag=0*/
  uint8_t tx_count;
  uint32_t mac_latency;
  uint8_t success; /*1: SUCCESS, 0: FAIL, only useful if flag=1*/
  
  /*added after x, y*/
  uint8_t last_hop_id;
  uint8_t queue_length;
  uint16_t num_pkt_dropped;
  uint8_t num_self_pkt_dropped;
  uint8_t num_dead_ngbr;
  uint8_t num_table_regeneration;
  uint8_t num_ngbr_switch;
}PACKED ReportedMsg;

#endif
