/*
 * @author: Brano Kusy, kusy@isis.vanderbilt.edu
 * Date last modified: jan05
 *
 * provides timestamping on transmitting/receiving SFD interrupt,uses 
 * SysTime (Timer3) to get local time 
 *
 */

configuration SysTimeStampingC
{
	provides
	{
		interface TimeStamping;
	}
}

implementation
{
	components NoLeds as LedsC; 
	components CC2420RadioM as Radio, 
	           HPLCC2420M, 
		   TimerC, LocalTimeMicroC,
	           TelosbSysTimeStampingM as SysTimeStampingM; 
	TimeStamping = SysTimeStampingM;
	
	SysTimeStampingM.RadioSendCoordinator -> Radio.RadioSendCoordinator;
	SysTimeStampingM.RadioReceiveCoordinator -> Radio.RadioReceiveCoordinator;
	SysTimeStampingM.HPLCC2420RAM    -> HPLCC2420M;
	SysTimeStampingM.Leds -> LedsC;
	SysTimeStampingM.LocalTime -> TimerC;
	SysTimeStampingM.LocalTimeMicro -> LocalTimeMicroC.LocalTime;
}
