
includes AM;

includes global;

//Hongwei
includes QueuedSend;
includes QueuedSendTuning; 

configuration QueuedSend {
  provides {
    interface StdControl;
    interface SendMsg[uint8_t id];
    interface QueueControl;
  }
}

implementation {
  components QueuedSendM,  
    GenericComm as Comm,
#ifndef TOSSIM
#ifndef PLATFORM_XSM
    CC2420ControlM as Radio,
    CC2420RadioC,
#else
    CC1000ControlM as Radio,
    CC1000RadioC,
#endif
#endif

    TimerC,
    NoLeds as Leds;

  StdControl = QueuedSendM;
  QueueControl = QueuedSendM; 
  SendMsg = QueuedSendM.QueueSendMsg;

  QueuedSendM.CommControl -> Comm.Control; 
  QueuedSendM.SerialSendMsg -> Comm.SendMsg;
  QueuedSendM.ReceiveMsg -> Comm.ReceiveMsg[QueuedSend_Tuning_Handler]; 

#ifndef TOSSIM
  QueuedSendM.RadioControl -> Radio;
#ifdef PLATFORM_XSM  
  QueuedSendM.MacControl -> CC1000RadioC;
#else
  QueuedSendM.MacControl -> CC2420RadioC;  
#endif
#endif

  QueuedSendM.TimerControl->TimerC;
  QueuedSendM.Timer -> TimerC.Timer[unique("Timer")];	

  QueuedSendM.Leds -> Leds; 
}
