
#ifndef QUEUEDSEND_H
#define QUEUEDSEND_H 

#include "AM.h"
#include "global.h"

#define MAX_TX_COUNT 8 //before packet redirection

//#define REDIRECT_FAIL_PKT 1 //to comment out if you do NOT want to redirect failed transmission 
#ifdef REDIRECT_FAIL_PKT
#define MAX_TX_IF_REDIRECT (MAX_TX_COUNT * 3) 
#endif

#define QS_USE_TASK_IN_TX 1 //to comment out if you do not want to reduce the number of tasks at runtime 

#define BASE_STATION_ADDR 0

#define SEND_QUEUE_SIZE	13

#define pendingDeadThreshold 3000 //150 //milliseconds; should be > QS_TIMER_INTERVAL

#define QS_TIMER_INTERVAL 128 //milliseconds 

typedef struct {
  ///* redundant: with pMsg?
  uint16_t address;
  uint8_t length;
  uint8_t id;
  //*/
  uint8_t xmit_count;
  uint32_t mac_latency;
  uint8_t last_hop;

TOS_Msg pMsg;
} msgq_entry_t;

typedef struct{ //6 bytes
  uint32_t delay;
  uint8_t tx_count; //also used to encode seqNo for packets on the air
  uint8_t source;
} link_pkt_head;

#define QUEUE_HEAD_LEN (sizeof(link_pkt_head))

typedef struct{
  uint8_t queueLen;
  uint8_t num_self_pkt_dropped;
  uint16_t num_pkt_dropped;
} queue_link_status;

#endif
