
#ifndef LOF_H
#define LOF_H

#include "QueuedSend.h"

#define EXPT_ONLY 1 //to comment out in real deployment: it will disable logging stats info; AND should initializae Comm and QueuedSend  

//Network configuration
#define BASE_STATION_ID 0  //ID of the base station 
#define MAX_NGBR_TABLE_SIZE 19 //24//28 //12, 28, 30, 48
#define MAX_NGBR_TO_CONSIDER 48 
#define MAX_NETWORK_SIZE 49 //in terms of # of nodes; used in defining variable served_list[...]

//=============================================================//
//#define SANITY_CHECK 1 //to comment out in real deployment 

//#define INIT_ESTIMATION_ONLY 1 //to leave uncommented if do not want to do online link est. (i.e., only use initial link est.)

//#define MAXIMIZE_HOP_COUNT 1 //to maximize hop count ETX based routing, i.e., use metric <ETX, - hop-count>
//#define MAXIMIZE_RELIABILITY 1 //to maximize hop count ETX based routing, i.e., use metric <ETX, - path-reliability>
#ifdef MAXIMIZE_RELIABILITY
#define UNICAST_RELIABILITY_CALC_BASE_NUM 7
#endif
#if defined(MAXIMIZE_HOP_COUNT) || defined(MAXIMIZE_RELIABILITY)
#define MAX_WEIGHT_CI_BOUND 98304//125000 //i.e., (NT_SCALE_FACTOR * SCALE_TEN / 2), for .5 tx-count
#endif

//#define USE_DETECTOR 1 //use detector to identify changes in network condition, esp. "bad => good"
#ifdef USE_DETECTOR
#define OPP_TRACKER 1 //to leave uncommented if want to use the opportunistic-tracker
#define USE_LETX_OR_WNT_AS_DETECTOR 1 //to leave uncommented if want to use 1/q (i.e., LETX) or 
                                                                                                  //WNTas the basis of detection
#define NO_BELIEF_PROPAGATION 1 //to comment out if a node want to propagate correctly detected transision "bad->good"
#endif

//#define USE_PER_PHY_TX_PER_NADV 1 //to use per-physical-layer tx feedback based PER as in NADV
//#define USE_WINDOW_NT 1 //to use window-based NT as the basis of routing metric
#define USE_DATA_DRIVEN_ETX 1 //instead of RNP-style, use ETX as defined by "1/link-reliability"

#define USE_TX_COUNT 1 //1) Use transmission count instead of mac latency 
                                                      //      (meaningful only if USE_DATA_DRIVEN_ETX is not defined)
                                                      //2) Should be left uncommented if USE_DETECTOR is defined (later): for change of net. condition

#define D_V_LOF 1             //distance vector
#ifdef D_V_LOF
//#define SNOOPING_BASED_RCVER_EST  1 //receiver snoops data packets to estimate DATA transmission reliability
#ifdef SNOOPING_BASED_RCVER_EST
//#define PIGGYBACK_RCVER_EST_ONTO_DATA 1 //Piggyback receiver-estimation info for one link to each txed data packet;
                                                                                                         //Also implies d-v-snooping
//#define NOT_CONSIDER_ACK_RELIABILITY 1 //do not consider ack reliability for non-next-hop candidate forwarders 
#endif
#define NON_GEO_DV 1 //the plain distance-vector protocol where backward (geographically speaking) links may be used 
//#define D_V_SNOOPING 1 //attach weight information to data packets to speed up convergence 
#define QUICK_BEACON 1	        //send a beacon if 1) weight changes significantly over the threshold QUICK_THRESHOLD, 
                                                                    //                         or 2) changed parent
#ifdef QUICK_BEACON
#define QUICK_THRESHOLD 5//10   //send beacon when weight change exceeds (1<<QUICK_THRESHOLD)/(1<<7)
#endif
#define PROBE_INTERVALS_PER_BEACON 2  //control beacon frequency to be so much slower than probing frequency
//#define BEACON_BASED_ESTIMATION 1 //to comment out if using data-driven link estimation
#ifdef BEACON_BASED_ESTIMATION 
//#define USE_RNP 1 //to comment out if using ETX as metric
#define CONSIDER_FORWARD_RELIABILITY 1 //to comment out if do not consider forward reliability
#define TTL_BEFORE_HEARING_ANOTHER_BEACON 10 
//#define ASSUME_SYMMETRIC_LINK 1 //if regard forward reliability as the same as backward reliability
#endif //BEACON_BASED_ESTIMATION
#endif //D_V_LOF

#if defined(USE_DETECTOR) || defined(SNOOPING_BASED_RCVER_EST)
#define LOG_LOF_DETECTOR 1  //to comment OUT in real deployment, and experimental study 
#endif

#define KEEP_PARENT_EVEN_IF_DEAD 1 //when do not want to lose parent even if it has been put into the blacklist (i.e., dead);
                                                                                         //but will still generate route-withdrawals, and will not reply to route request.

//#define USE_NGBR_SWITCH 1 //comment out this, if not wanting to use neighbor switching 
#ifdef USE_NGBR_SWITCH
//#define SWITCH_DEAD_NGBR 1 //comment out this, if not wanting to switch any dead neighbors 
#define NUM_PER_NODE_PKTS_BETWEEN_NET_CONDITION_CHANGE 20 //10,20,5,15,30,40
                                                                                                                       //To reflect network temporal changes; 
                                                                                                                       //should be no more than (0xffff/MAX_NGBR_TABLE_SIZE - 1)
#endif

//#define USE_GRID_HOP_DIST 1 //to comment out if use cartesian distance

#define FB_PENALIZE_UPON_FAILURE 1 //to comment out if NOT use 1/q penalizing factor upon a MAC transmission failure  

#ifdef SNOOPING_BASED_RCVER_EST
#define MAX_NUM_NODES_TO_SNOOP (MAX_NETWORK_SIZE) //large enough so that no need to manage table space
#define FREQ_RATIO_FOR_POTENTIAL_CHILD 2//4 //send information related to frequent transmitters more freqently
#define FLAG_NOT_INITIALIZED BASE_STATION_ID
typedef struct snooping_link_est {
  uint8_t src; //node id
  uint8_t last_tx_seqNo;
  uint8_t numSend;
  uint8_t numSucc;
  uint16_t linkReliability;

  bool potentialChild; //whether the node is a potential child, i.e., currently has larger cost to destination
} snooping_link_est_t;
#endif

#define CHECK_FB_ADDR 1 //to comment out if not check whether .addr == lof.parent_id 

#define SUPPRESS_DUPLICATE_PKT 1 //to comment out if want to save some RAM 
#ifdef SUPPRESS_DUPLICATE_PKT
#define MAX_NUM_CHILDREN 20 
typedef struct duplicate_detector {
  uint8_t child;
  uint8_t last_seqNo;
} duplicate_detector_t;
#endif

#define USE_AGE_FACTOR 1 

//===============================================================//
#define MAX_TABLE_SIZE_DB ( MAX_NGBR_TABLE_SIZE * (MAX_NGBR_TABLE_SIZE - 1) / 2 ) 

#define NT_SCALE_FACTOR 24576//i.e., 3 << 13, and ~25000 //~MAC-latency (in microseconds) to transmit a packet 

//#define LOG_PROBBEINGBEST 1 //record probability being best 
//#define LOG_ORDERING 1  //record routing table ordering information for potential parents
//#define LOG_MEAN_VARIANCE 1 //record mean and variance 

//---------------------------------------------------------
#ifdef USE_DETECTOR  //for the case of "bad => good network condition"

#ifdef OPP_TRACKER
#define STATE_OPP_TRACKING_NO 10
#define STATE_OPP_TRACKING_IN_DETECTION 11
#define STATE_OPP_TRACKING_SH 12 //handling opportunistic tracking 

#define OPP_TRACKING_STABILITY_DETECTOR 3
#define OPP_TRACKING_STARTING_CANDIDATE_POTENTIAL 5
#endif

#define STATE_NORMAL 0
#define STATE_IN_DETECTION 1 //local
#define STATE_INFORMED_DETECTION 2 //from others
#define STATE_SPECIAL_HANDLING 3

#define comp_detector_pastW 2 //pastW == 3/4
#define MIN_THRESHOLD (NT_SCALE_FACTOR) //also as initial threshold
#define MAX_THRESHOLD 122880//125000 //i.e., (5*NT_SCALE_FACTOR)
#define THRESHOLD_ADAPT_STEP 12288//12500 //i.e., (NT_SCALE_FACTOR/2)   //for feedback control; 0.5 number of transmissions

#define INIT_IMPROVED_NET_CONDITION_HOLD_WINDOW 8//4,8  //temporal stability of improved network condition 
#define MIN_IMPROVED_NET_CONDITION_HOLD_WINDOW 4//2,4 
#define MAX_IMPROVED_NET_CONDITION_HOLD_WINDOW 16//8,16 
#define HOLD_WINDOW_ADAPT_STEP 2 //1,2

#define STARTING_CANDIDATE_POTENTIAL 2 //sample size 2 covers 75% cases 
#define STARTING_CANDIDATE_POTENTIAL_INFORMED 1 

#define DETECTOR_INITIATOR_NO 0
#define DETECTOR_INITIATOR_SELF 1
#define DETECTOR_INITIATOR_OTHERS 2
#define DETECTOR_INITIATOR_OTHERS_THRESHOLD_TOO_HIGH 3

#define DETECTOR_SEQ_NO_INC_INTERVAL 120000 //2 minutes

typedef struct lof_detector {
  uint32_t seq;
  uint8_t hops;
} lof_detector_t;

#define NOT_TO_PROPAGATE 0 
#define MAY_PROPAGATE 1
#define TO_PROPAGATE 2
#define MAX_PROP_HOPS  6 //max # hops to propogate

#define PROP_HOLDING_TIME 30000 //on average: 15 seconds
#define NUM_OTHER_PROGS_TO_COVER_SELF 3

#endif //USE_DETECTOR
//---------------------------------------------------------

/* beancon-free routing/estimation */
#define MAX_PROBE_INTERVAL 20000 //10 seconds on average 
#define NUM_PROBES_EACH_ROUND 7   //for reliable probe-request, probe-reply 
#define NUM_INIT_SAMPLES 7 //for initializing routing metric 

#define MAX_INIT_EST_FB_DELAY 12 //in terms of probe interval

/* dead neighbor control */
#define DEAD_IF_FAIL_FIRST_CONSECUTIVE_INIT_ESTS 6 //must be less than NUM_INIT_SAMPLES;
                                                                                                              //can be conservatively set to be large since we have reliability based
                                                                                                              //blacklisting
#ifdef BEACON_BASED_ESTIMATION
#define LINK_RELIABILITY_CALC_BASE_NUM 10 //
#else
#define LINK_RELIABILITY_CALC_BASE_NUM 20//20,1,5,10,30,40 //new estimates every such number of broadcast send-operations; 
                                                                                                         //should be no more than 255
#endif
#define CONSECUTIVE_SUCCESS_CALC_BASE 7 //i.e., if consecutive tx success exceeds this number, do another period
#define LINK_RELIABILITY_SCALE_FACTOR_LEFT_SHIFT 10 //i.e., *1024
#define PERFECT_RELIABILITY 1024
#define MIN_LIVING_NGBR_LINK_RELIABILITY ((20 << LINK_RELIABILITY_SCALE_FACTOR_LEFT_SHIFT) /100) //20%
#define MAX_CONSECUTIVE_FAIL 7 //after which, declare as "dead" neighbor; 
                                                                             //related to DEAD_IF_FAIL_CONSECUTIVE_INIT_ESTS
#define MIN_RELIABILITY 1 //((0.1 << LINK_RELIABILITY_SCALE_FACTOR_LEFT_SHIFT) / 100)

#define IS_ALIVE 1
#define IS_DEAD 0   //must be less than IS_ALIVE

#define TIMER_INTERVAL 128 //milliseconds

#define RANDOM_NUM_MAX 60000 //unsigned 16-bit

/* for routing control */
#define compPastW 4 //original - (original>>compPastW)
#define compPastDevW 2 //original - (original>>compPastDevW)

#define PROBE_REQUEST 1
#define PROBE_REPLY 4
#define PROBE_WITHDRAWAL 7
#define PROBE_LINK_ESTIMATION 10
#define PROBE_BEACON 13
#ifdef USE_DETECTOR
#define PROBE_DETECTION 16 //for deteciton propogation
#endif

#define PKT_TYPE_LOF 30 //for LOF data packets

#define SCALE_TEN 10 //<<3
#define SCALE_HUNDRED 100 //<<6
#define SCALE_THOUSAND 1000 //<<10
#define SCALE_TENTHOUSAND 10000

//------------------------------------------
typedef struct lof_pkt_head { //max 11 bytes
  uint8_t src; //0) encapsulated in link header at QueuedSend; 
                        //1) used to identify whether a packet is locally generated, and if not, the last-hop from which the packet has come 

#ifdef NON_GEO_DV
  uint8_t generator;  //original source of the packet; used for loop detection that 
                                     //assumes that every node is generating packets indefinitely
#endif

#ifdef SUPPRESS_DUPLICATE_PKT
  uint8_t seqNo; //seqNo for the current link used; for duplicate suppression
  /*
    #if defined(PLATFORM_TELOS) && !defined(NON_GEO_DV)
    uint8_t dummy;
    #endif
  */
#endif

#if defined(D_V_SNOOPING) || defined(SNOOPING_BASED_RCVER_EST)
  uint32_t weight;
#ifdef MAXIMIZE_HOP_COUNT
  uint8_t numHops;
#elif defined(MAXIMIZE_RELIABILITY)
  uint16_t pathReliability;
#endif
#endif 

#ifdef SNOOPING_BASED_RCVER_EST
  uint8_t rcver_est_src;
  uint16_t rcver_est_linkReliability;
#endif
} lof_pkt_head;

#define LOF_PKT_HEAD_LEN (sizeof(lof_pkt_head))
#define LOF_HEAD_LEN (LOF_PKT_HEAD_LEN + QUEUE_HEAD_LEN)
#define LOF_PKT_DATA_LEN (TOSH_DATA_LENGTH - LOF_HEAD_LEN)

typedef struct loc_t{
  uint8_t x;
  uint8_t y;
} loc_t;   /*location*/

#define SERVED_FLAG 1
#define NOT_SERVED_FLAG 0

#define LINK_BROADCAST 0xff

// The structure of the heartbeat packet
typedef struct linkReliability_list {
  uint8_t src;
  uint16_t linkReliability;
} linkReliability_list_t;
#if defined(BEACON_BASED_ESTIMATION) || defined(SNOOPING_BASED_RCVER_EST)
#define MAX_ENTRIES_CARRIED_PER_HB 5//4
#endif
typedef struct lof_heartbeat {//up to 25 bytes; Being prefixed by QueuedSend
  uint8_t type;
  uint8_t src; //0) used to identify the source of beacon, heartbeat, initial link estimation packet
                        //1) original source of detection packet

  uint8_t num_probe_to_send; //this field is not used any more 
  /*
    #ifdef PLATFORM_TELOS
    uint8_t dummy;
    #endif
  */

#ifdef D_V_LOF
  uint32_t weight;
#endif

#ifdef MAXIMIZE_HOP_COUNT
  uint8_t numHops;
#elif defined(MAXIMIZE_RELIABILITY)
  uint16_t pathReliability;
#endif 

#ifdef BEACON_BASED_ESTIMATION
  uint8_t hb_seqNo; //in BEACON_BASED_ESTIMATION
#elif defined(SNOOPING_BASED_RCVER_EST)
  uint8_t parent_id; //in SNOOPING_BASED_RCVER_EST
#endif

#if defined(BEACON_BASED_ESTIMATION) || defined(SNOOPING_BASED_RCVER_EST)
  linkReliability_list_t lrList[MAX_ENTRIES_CARRIED_PER_HB];
#endif
} lof_heartbeat_t;

#define LOF_HB_PKT_SIZE (QUEUE_HEAD_LEN + sizeof(lof_heartbeat_t))

//An element maintained for each active neighbor
typedef struct ngbr_table {
#ifdef SUPPRESS_DUPLICATE_PKT 
  uint8_t seqNo;  //# of application packets forwarded via this neighbor
#endif

#ifdef USE_DETECTOR
  uint8_t candidatePotential;   //0: not being a candidate for special handling    
                                                       //>0 && <100: still being a candidate for special sampling
                                                       //                         Decrease by 1 each time the neighbors routing-order and/or windowSum does not improve
                                                       //>=100: used as an indicator whether the improved network condition hold long enough 
                                                       //Initialized to 0
  uint32_t detectorLQI;   //initialized to 0; 
                                              //the reason that this is used in addition to field "diliveryLatency" is that 
                                              //a smaller pastW (e.g., 3/4 instead of 15/16) is used here
  uint32_t devDetectorLQI; //initialized to 0 
  uint32_t last_level_of_entry; //initialized to 0
#ifdef OPP_TRACKER
  uint32_t oppTrackerLQI; //initialized to 0
  uint8_t oppNode; 
#endif
#endif

#ifdef USE_AGE_FACTOR
  uint16_t seq_no;	//in real deployment, change to uint32_t; record the LOF-level seq. no of the packet last sent via this ngbr
#endif

  uint8_t node_id;  	   //NOTE: should be set to uint16_t if the range of node-id exceeds 255
   
  uint8_t numInitSamplesToTake; //for initializing routing metric

  uint8_t numSend; //# of packets send; initialized to 0 
  uint8_t numSucc; //initialized to 0 
  uint16_t link_reliability;  //broadcast link reliability;
                                                 //if USE_RNP, this field is used to record estimated RNP value;
                                                 //if USE_PER_PHY_TX_PER_NADV, this field is used to record estimated packet error rate.
#ifdef SNOOPING_BASED_RCVER_EST
  uint16_t ackReliability;
#endif 
  uint8_t consecutive_tx_failure; //initialized to 0
  uint8_t liveness;       //whether reachable
#ifdef BEACON_BASED_ESTIMATION
  uint8_t ttl;
#endif

#if !defined(D_V_LOF) || defined(MAXIMIZE_HOP_COUNT)
  uint16_t numHops;   //route hop count;
                                         //In L-ETX: it is the reciprocal of the effective geographic-progress toward the destination; 
                                         //                    be SCALED up by a factor of "100".
#endif

#ifdef MAXIMIZE_RELIABILITY
#ifdef D_V_LOF
  uint16_t ngbrPathReliability;  //for the path from the neighbor to destination
#else
  uint16_t estGeoHops; 
#endif

  uint16_t pathReliability;
  uint8_t numDataSend;
  uint8_t numDataSucc;
  uint16_t data_reliability;  //for this local link
#endif

  /* Hongwei
     uint32_t deliveryLatency; //microseconds; initialized to 0
     uint32_t devDeliveryLatency; //standard deviation of deliveryLatency; initialized to -1 (to avoid "divided by 0") 
     uint32_t devLog; //initialized to -1 (to avoid "divided by 0") 
     uint32_t deliveryLatency_Log;
  */

  uint32_t weight;  //for route selection: measure the routing-metric if using this neighbor as the forwarder; 
                                  //Geographic routing: scaled up by 100 because numHops is scaled up by 100; 
                                  //D-V routing: scaled up by 10 (to improve precision for LOF_log()).

#ifndef USE_NGBR_SWITCH
  uint32_t devWeight;
#else
  uint16_t logWeight;  //scaled up by a factor of 100
  uint16_t devLogWeight; //scaled up by a factor of 100, because logWeight is scaled up by a factor of 100 
#endif
#if defined(MAXIMIZE_HOP_COUNT) || defined(MAXIMIZE_RELIABILITY)
  uint16_t n;
  uint32_t CI_bound;
#endif

#ifdef D_V_LOF
  uint32_t ngbr_weight;  //weight of this neighbor  
#endif

#if defined(BEACON_BASED_ESTIMATION)
  uint8_t last_hb_seqNo;
  uint16_t forwardReliability;
#endif

#ifdef USE_NGBR_SWITCH
  uint16_t probBeingBest;
  uint16_t rangeLower; //for comparing probability
  uint16_t rangeUpper;
#endif
}  ngbr_table_t;


typedef struct ngbr_table_index{
  uint8_t flag; //1: used    0: not used
  uint8_t index; //pointer to an element of neighbor table
  struct ngbr_table_index* next;
} ngbr_table_index_t;


typedef struct ngbr_metric_index{  //for initial link estimation
  uint8_t node_id;
#ifdef PLATFORM_TELOS
  uint8_t dummy;
#endif
#ifdef D_V_LOF
  uint32_t ngbr_weight;
#endif
#ifdef MAXIMIZE_HOP_COUNT
  uint8_t ngbr_numHops;
#elif defined(MAXIMIZE_RELIABILITY)
  uint16_t ngbr_pathReliability;
#endif

  struct ngbr_metric_index* next;
} ngbr_metric_index_t;


typedef struct ngbr_pairprob{
  ngbr_table_index_t* ptr1;
  ngbr_table_index_t* ptr2;
  uint16_t prob; 
} ngbr_pairprob_t;


/* The structure to maintain the state of the LOF module */
typedef struct lof_routing_state {
  uint8_t numRouteWithdrawalToSend; //When do not have any parent; initialized to NUM_PROBES_EACH_ROUND
  uint8_t numProbeReplyToSend;     //Starts sending probe reply when first found a parent; initialized to 0
  uint8_t numProbeRequestToSend; //Send probe-request when already has a parent, but need to make sure to hear 
                                                                   //probe reply from all potential parents; initialized to 0

  //  uint8_t base_id;
  loc_t base_loc;
  uint8_t parent_id;	//the id of parent

  uint8_t ngbr_table_size; //initialized to 0
  ngbr_table_index_t* ngbr_table_head; //identifies the neighbor list, including BOTH alive and dead neighbors but 
                                                                          //?NOT including those explicitly withdrawn

  ngbr_table_index_t* initialEstNgbr; //the neighbor w.r.t. whom initial link estimation is being or to be done the next time
  ngbr_metric_index_t* initialEst_head; //"initial estimation" that is yet to be done
  ngbr_metric_index_t* initialEst_tail;

#ifdef USE_NGBR_SWITCH
  uint16_t pktsBeforeSwitching; //initialized to 0xffff
#endif

  uint16_t last_seqno;	   /* last seqno used; only at the layer of LOF; initialized to 0 */ 
}  lof_routing_state_t;


/***********************************
 * Utility functions
 ***********************************/
uint32_t LOF_pow(uint32_t x, uint8_t pw); 
uint32_t  LOF_sqrt(uint32_t x);
int32_t LOF_log(uint32_t x);

uint32_t prob_greater(uint32_t u1, uint32_t delta1, uint32_t u2, uint32_t delta2);

uint32_t distance(loc_t* locationA, loc_t* locationB);
uint8_t distanceCmp(loc_t* baseLocation, loc_t* locationA, loc_t* locationB);

#include "LOF_math.c"

#endif
