/***********************************************************************************
    Copyright (C) <2005>  <Hongwei Zhang>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    Author:
    =======
    Hongwei Zhang
    Department of Computer Science and Engineering
    The Ohio State University, USA

    E-mail: zhangho@cse.ohio-state.edu

***********************************************************************************/


/*
 * iwtxstatus.h
 *
 * Author: Hongwei Zhang, CSE, OSU
 *    zhangho@cis.ohio-state.edu
 */


#ifndef _IWTXSTATUS_H
#define _IWTXSTATUS_H

#define DEBUG_FB_NUM 1 //to be commented out in real demo
//#define IWTXSTATUS_DEBUG 1 //to be commented out in real demo; only prints out fb info, but not sending to linxyd

#define NET_LINK_RCV_BUF_SIZE 65535 //bytes; default is ???
#define UDP_SEND_BUF_SIZE 36000 //bytes; default is 9000 in most systems

#define MAC_FEEDBACK_LINXY_UDP_PORT 4960 //the port via which data is sent to linxy
#define MAC_FEEDBACK_IWTX_UDP_PORT 4961

#define PROC_FB_DELAY_FILE "/proc/fb_delay"
#define DEFAULT_FB_DELAY 1000 //microseconds

#define WIRELESS_IFNAME "wlan0"  
#define IWEVTXSUCC 0x8C02      //copied from .../linux.../include/linux/wireless.h
#define MAC_ADDR_DISPLAY_LEN 2*6 + 5 + 1

typedef struct linxy_iwtx_pkt {
  int status;   //1: success       -1: failure
  //int retry;    //# of retries
  long fb_delay;  //MAC feedback delay; in microseconds
  long bitrate;   //NIC bitrate: bit/second
  struct timeval rcv_time;
  char mac_addr[MAC_ADDR_DISPLAY_LEN];
} linxy_iwtx_pkt_t;

#endif  
