/***********************************************************************************
    Copyright (C) <2005>  <Hongwei Zhang>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    Author:
    =======
    Hongwei Zhang
    Department of Computer Science and Engineering
    The Ohio State University, USA

    E-mail: zhangho@cse.ohio-state.edu

***********************************************************************************/


/*
 * iwtxstatus.c
 *
 * Author: Hongwei Zhang
 *                 CSE, OSU
 *    zhangho@cis.ohio-state.edu
 *
 * Based on iwevent.c
 */

/***************************** INCLUDES *****************************/

#include "iwlib.h"		/* Header */

//Hongwei
#include "iwtxstatus.h"
//#include <linux/wireless.h>

#include <linux/netlink.h> 
#include <linux/rtnetlink.h>

#include <getopt.h>
#include <time.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <netinet/in.h>
    
/* Ugly backward compatibility :-( */
#ifndef IFLA_WIRELESS
#define IFLA_WIRELESS	(IFLA_MASTER + 1)
#endif /* IFLA_WIRELESS */


//Hongwei
int skfd;	//the socket via which to get information about the NIC (same as used by iwconfig.c): bit rate ...
int sock_fd; //the socket descriptor via which to send reports to linxy
char * ifname = WIRELESS_IFNAME; 
#ifdef DEBUG_FB_NUM
int num_rcv = 0;
int num_sent = 0;
#endif


/* utility to get the last feedback delay */
long get_fb_delay(void)
{
  long d;
  char buf[100];

  FILE * fd = fopen(PROC_FB_DELAY_FILE, "r");

  if (fd == NULL) {
    printf("Error: cannot open file %s \n", PROC_FB_DELAY_FILE);
    d = DEFAULT_FB_DELAY;
  }
  else {
    fscanf(fd, "%s", buf);
    d = atol(buf);
#ifdef IWTXSTATUS_DEBUG 
    printf("the feedback delay = %s us   ", buf);
#endif
  }

  fclose (fd);
  return d;
} //end of get_fb_delay()


//Hongwei: used in print_event_token(...)
void send_to_linxy(linxy_iwtx_pkt_t * fb_pkt)
{
  int retval;
  int i;

#ifdef DEBUG_FB_NUM
  num_rcv++;
#endif

  struct sockaddr_in sa = {
    sin_family: AF_INET,
    sin_port: htons(MAC_FEEDBACK_LINXY_UDP_PORT),
    sin_addr: {s_addr: INADDR_ANY}
  };

  for (i=1; i <= 5; i++) {
    retval = sendto(sock_fd, (char *)fb_pkt, sizeof(linxy_iwtx_pkt_t), 0, (struct sockaddr *)&sa, sizeof(sa));
    if (retval < 0) 
      printf("iwtxstatus: failed to send UDP packet to linxy: %m\n");
    else if ((unsigned int)retval < sizeof(linxy_iwtx_pkt_t))
      printf("iwtxstatus: short write for UDP packet to linxy: %d/%d:  %m\n", retval, sizeof(linxy_iwtx_pkt_t));
    else if (retval == sizeof(linxy_iwtx_pkt_t)) {
#ifdef DEBUG_FB_NUM
      num_sent++;
      printf(">>>>>>>> iwtxstatus: NUM_RCV = %d        NUM_SENT = %d\n", num_rcv, num_sent);
#endif
      //printf("iwtxstatus: successfully reports to linxy\n");
      break;
    }
  }

  free(fb_pkt);
  return;
} //end of send_to_linxy


#if WIRELESS_EXT > 13
/*------------------------------------------------------------------*/
/*
 * Print one element from the scanning results
 */
static inline int
print_event_token(struct iw_event *	event,	/* Extracted token */
		  char *		ifname
		  )/*,
		  struct iw_range *	iwrange,	//Range info
		  int		has_iwrange)
		   */
{
  //Hongwei
  struct iwreq  wrq;

#ifndef IWTXSTATUS_DEBUG
  //Hongwei
  linxy_iwtx_pkt_t * fb_pkt; 
#else
  //default: char		buffer[128];  //Temporary buffer
  char		buffer[MAC_ADDR_DISPLAY_LEN];  
  //Hongwei
  struct timeval	rcv_time;
  struct iw_statistics  stats;
#endif

  /* Now, let's decode the event */
  switch(event->cmd)
    {
      //Hongwei
    case IWEVTXSUCC:
#ifndef IWTXSTATUS_DEBUG
      if ((fb_pkt = malloc(sizeof(linxy_iwtx_pkt_t))) == NULL) {
	printf("iwtxstatus: failed to allocate space for an incoming event\n");
	exit(-1);
      }
      fb_pkt->status = 1;
      fb_pkt->fb_delay = get_fb_delay();
      gettimeofday(&(fb_pkt->rcv_time), NULL);
      iw_pr_ether(fb_pkt->mac_addr, event->u.addr.sa_data);
      //get retry count
      //fb_pkt->retry = u.addr.sa_family;
      //get bit rate 
      if(iw_get_ext(skfd, ifname, SIOCGIWRATE, &wrq) >= 0)
	fb_pkt->bitrate = wrq.u.bitrate.value;
      else 
	fb_pkt->bitrate = -1;
      send_to_linxy(fb_pkt); 
#else
      gettimeofday(&rcv_time, NULL);
      iw_print_timeval(buffer, &rcv_time); //defined in iwlib.{ch}
      //get bit rate 
      if(iw_get_ext(skfd, ifname, SIOCGIWRATE, &wrq) >= 0) {
	printf("bit rate == %d \n", wrq.u.bitrate.value); 
      }
      get_fb_delay(); 
      //get link statistics
      if(iw_get_stats(skfd, ifname, &stats) >= 0)
	printf("iw_statistics: qual = %d     level = %d dBm  noise = %d dBm   updated = %d\n",
 	                stats.qual.qual, stats.qual.level-256, stats.qual.noise-256, stats.qual.updated);
      //output
      printf("%s   %-8.8s      ", buffer, ifname);
      printf("1   %s\n",  iw_pr_ether(buffer, event->u.addr.sa_data)); //defined in iwlib.{ch}
#endif
      break; 

    case IWEVTXDROP:
#ifndef IWTXSTATUS_DEBUG
      if ((fb_pkt = malloc(sizeof(linxy_iwtx_pkt_t))) == NULL) {
	printf("iwtxstatus: failed to allocate space for an incoming event\n");
	exit(-1);
      }
      fb_pkt->status = -1;
      fb_pkt->fb_delay = get_fb_delay();
      gettimeofday(&(fb_pkt->rcv_time), NULL);
      iw_pr_ether(fb_pkt->mac_addr, event->u.addr.sa_data);
      //get retry count
      //fb_pkt->retry = u.addr.sa_family;
      //get bit rate 
      if(iw_get_ext(skfd, ifname, SIOCGIWRATE, &wrq) >= 0)
	fb_pkt->bitrate = wrq.u.bitrate.value;
      else 
	fb_pkt->bitrate = -1; 
      send_to_linxy(fb_pkt);
#else 
      gettimeofday(&rcv_time, NULL);
      iw_print_timeval(buffer, &rcv_time);
      //get bit rate 
      if(iw_get_ext(skfd, ifname, SIOCGIWRATE, &wrq) >= 0) {
	printf("bit rate == %d \n", wrq.u.bitrate.value); 
      }
      get_fb_delay();
      //get link statistics
      if(iw_get_stats(skfd, ifname, &stats) >= 0)
	printf("iw_statistics: qual = %d     level = %d dBm  noise = %d dBm   updated = %d\n",
 	                stats.qual.qual, stats.qual.level-256, stats.qual.noise-256, stats.qual.updated);
      //output
      printf("%s   %-8.8s      ", buffer, ifname); 
      printf("-1   %s\n",  iw_pr_ether(buffer, event->u.addr.sa_data));
#endif
      break;
    default:
      //printf("events received\n");
      ;
    }	/* switch(event->cmd) */

  return(0);
}

#endif



/************************ RTNETLINK HELPERS ************************/
/*
 * The following code is extracted from :
 * ----------------------------------------------
 * libnetlink.c	RTnetlink service routines.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 * Authors:	Alexey Kuznetsov, <kuznet@ms2.inr.ac.ru>
 * -----------------------------------------------
 */

struct rtnl_handle
{
	int			fd;
	struct sockaddr_nl	local;
	struct sockaddr_nl	peer;
	__u32			seq;
	__u32			dump;
};

static inline void rtnl_close(struct rtnl_handle *rth)
{
	close(rth->fd);
}

static inline int rtnl_open(struct rtnl_handle *rth, unsigned subscriptions)
{
	int addr_len;

	memset(rth, 0, sizeof(rth));

	rth->fd = socket(PF_NETLINK, SOCK_RAW, NETLINK_ROUTE);
	if (rth->fd < 0) {
		perror("Cannot open netlink socket");
		return -1;
	}

	memset(&rth->local, 0, sizeof(rth->local));
	rth->local.nl_family = AF_NETLINK;
	rth->local.nl_groups = subscriptions;

	if (bind(rth->fd, (struct sockaddr*)&rth->local, sizeof(rth->local)) < 0) {
		perror("Cannot bind netlink socket");
		return -1;
	}
	addr_len = sizeof(rth->local);
	if (getsockname(rth->fd, (struct sockaddr*)&rth->local, &addr_len) < 0) {
		perror("Cannot getsockname");
		return -1;
	}
	if (addr_len != sizeof(rth->local)) {
		fprintf(stderr, "Wrong address length %d\n", addr_len);
		return -1;
	}
	if (rth->local.nl_family != AF_NETLINK) {
		fprintf(stderr, "Wrong address family %d\n", rth->local.nl_family);
		return -1;
	}
	rth->seq = time(NULL);
	return 0;
}

/********************* WIRELESS EVENT DECODING *********************/
/*
 * This is the bit I wrote...
 */

#if WIRELESS_EXT > 13

/*------------------------------------------------------------------*/
/*
 * Print out all Wireless Events part of the RTNetlink message
 * Most often, there will be only one event per message, but
 * just make sure we read everything...
 */
static inline int print_event_stream(char *	ifname,
		   char *	data,
		   int		len)
{
  struct iw_event	iwe;
  struct stream_descr	stream;
  //  int			i = 0;
  int			ret;
  //char			buffer[64];
  //struct timeval	recv_time;
#if 0
  struct iw_range	range;
  int			has_range;
#endif

#if 0
  has_range = (iw_get_range_info(skfd, ifname, &range) < 0);
#endif

  /* In readable form */
  /*Commented out by Hongwei
  gettimeofday(&recv_time, NULL);
  iw_print_timeval(buffer, &recv_time);
  */

  iw_init_event_stream(&stream, data, len);
  //  /*Commented out by Hongwei
  do
    {
//  */
      /* Extract an event and print it */
      ret = iw_extract_event_stream(&stream, &iwe);
      if(ret != 0) {
	  /*commented out by Hongwei
	  if(i++ == 0)
	    printf("%s   %-8.8s ", buffer, ifname);
	  else
	    printf("                           ");
	  */
	  if(ret > 0)
	    print_event_token(&iwe, ifname); //Hongwei: , NULL, 0);
	  else
	    printf("(Invalid event)\n");
      }
      ///* commented out by Hongwei
  }
  while(ret > 0);
//*/

  return(0);
}
#endif	/* WIRELESS_EXT > 13 */

/*********************** RTNETLINK EVENT DUMP***********************/
/*
 * Dump the events we receive from rtnetlink
 * This code is mostly from Casey
 */

/*------------------------------------------------------------------*/
/*
 * Respond to a single RTM_NEWLINK event from the rtnetlink socket.
 */
static inline int
index2name(int	index, char *name)
{
  int		skfd = -1;	/* generic raw socket desc.	*/
  struct ifreq	irq;
  int		ret = 0;

  memset(name, 0, IFNAMSIZ + 1);

  /* Create a channel to the NET kernel. */
  if((skfd = iw_sockets_open()) < 0)
    {
      perror("socket");
      exit(-1);
    }

  /* Get interface name */
  irq.ifr_ifindex = index;
  if(ioctl(skfd, SIOCGIFNAME, &irq) < 0)
    ret = -1;
  else
    strncpy(name, irq.ifr_name, IFNAMSIZ);

  close(skfd);
  return(ret);
}


/*------------------------------------------------------------------*/
/*
 * Respond to a single RTM_NEWLINK event from the rtnetlink socket.
 */
static int
LinkCatcher(struct nlmsghdr *nlh)
{
  struct ifinfomsg* ifi;
  char ifname[IFNAMSIZ + 1];

#if 0
  fprintf(stderr, "nlmsg_type = %d.\n", nlh->nlmsg_type);
#endif

  if(nlh->nlmsg_type != RTM_NEWLINK)
    return 0;

  ifi = NLMSG_DATA(nlh);

  /* Get a name... */
  index2name(ifi->ifi_index, ifname);

#if WIRELESS_EXT > 13
#ifndef IFLA_WIRELESS
#define IFLA_WIRELESS 11
#endif
  /* Code is ugly, but sort of works - Jean II */

  /* Check for attributes */
  if (nlh->nlmsg_len > NLMSG_ALIGN(sizeof(struct ifinfomsg))) {
      int attrlen = nlh->nlmsg_len - NLMSG_ALIGN(sizeof(struct ifinfomsg));
      struct rtattr *attr = (void*)ifi + NLMSG_ALIGN(sizeof(struct ifinfomsg));

      while (RTA_OK(attr, attrlen)) {
	/* Check if the Wireless kind */
	if(attr->rta_type == IFLA_WIRELESS) {
	  /* Go to display it */
	  print_event_stream(ifname,
			     (void *)attr + RTA_ALIGN(sizeof(struct rtattr)),
			     attr->rta_len - RTA_ALIGN(sizeof(struct rtattr)));
	}
	attr = RTA_NEXT(attr, attrlen);
      }
  }
#endif	/* WIRELESS_EXT > 13 */

  return 0;
}


/* ---------------------------------------------------------------- */
/*
 * We must watch the rtnelink socket for events.
 * This routine handles those events (i.e., call this when rth.fd
 * is ready to read).
 */
static inline void
handle_netlink_events(struct rtnl_handle *	rth)
{
  while(1)
    {
      struct sockaddr_nl sanl;
      socklen_t sanllen;

      struct nlmsghdr *h;
      int amt;
      char buf[8192];

      amt = recvfrom(rth->fd, buf, sizeof(buf), MSG_DONTWAIT, (struct sockaddr*)&sanl, &sanllen);
      if(amt < 0)
	{
	  if(errno != EINTR && errno != EAGAIN)
	    {
	      fprintf(stderr, "%s: error reading netlink: %s.\n",
		      __PRETTY_FUNCTION__, strerror(errno));
	    }
	  return;
	}

      if(amt == 0)
	{
	  fprintf(stderr, "%s: EOF on netlink??\n", __PRETTY_FUNCTION__);
	  return;
	}

      h = (struct nlmsghdr*)buf;
      while(amt >= (int)sizeof(*h))
	{
	  int len = h->nlmsg_len;
	  int l = len - sizeof(*h);

	  if(l < 0 || len > amt)
	    {
	      fprintf(stderr, "%s: malformed netlink message: len=%d\n", __PRETTY_FUNCTION__, len);
	      break;
	    }

	  switch(h->nlmsg_type)
	    {
	    case RTM_NEWLINK:
	      LinkCatcher(h);
	      break;
	    default:
#if 0
	      fprintf(stderr, "%s: got nlmsg of type %#x.\n", __PRETTY_FUNCTION__, h->nlmsg_type);
#endif
	      break;
	    }

	  len = NLMSG_ALIGN(len);
	  amt -= len;
	  h = (struct nlmsghdr*)((char*)h + len);
	}

      if(amt > 0)
	fprintf(stderr, "%s: remnant of size %d on netlink\n", __PRETTY_FUNCTION__, amt);
    }
}

/**************************** MAIN LOOP ****************************/

/* ---------------------------------------------------------------- */
/*
 * Wait until we get an event
 */
static inline int 
wait_for_event(struct rtnl_handle *	rth)
{
#if 0
  struct timeval	tv;	/* Select timeout */
#endif

  /* Forever */
  while(1)
    {
      fd_set		rfds;		/* File descriptors for select */
      int		last_fd;	/* Last fd */
      int		ret;

      /* Guess what ? We must re-generate rfds each time */
      FD_ZERO(&rfds);
      FD_SET(rth->fd, &rfds);
      last_fd = rth->fd;

      /* Wait until something happens */
      ret = select(last_fd + 1, &rfds, NULL, NULL, NULL);

      /* Check if there was an error */
      if(ret < 0)
	{
	  if(errno == EAGAIN || errno == EINTR)
	    continue;
	  fprintf(stderr, "Unhandled signal - exiting...\n");
	  break;
	}

      /* Check if there was a timeout */
      if(ret == 0)
	{
	  continue;
	}

      /* Check for interface discovery events. */
      if(FD_ISSET(rth->fd, &rfds))
	handle_netlink_events(rth);
    }

  return(0);
}


/******************************* MAIN *******************************/

/* ---------------------------------------------------------------- */
/*
 * helper ;-)
 */
static void
iw_usage(int status)
{
  fputs("Usage: iwevent [OPTIONS]\n"
	"   Monitors and displays Wireless Events.\n"
	"   Options are:\n"
	"     -h,--help     Print this message.\n"
	"     -v,--version  Show version of this program.\n",
	status ? stderr : stdout);
  exit(status);
}
/* Command line options */
static const struct option long_opts[] = {
  { "help", no_argument, NULL, 'h' },
  { "version", no_argument, NULL, 'v' },
  { NULL, 0, NULL, 0 }
};

/* ---------------------------------------------------------------- */
/*
 * main body of the program
 */
int main(int	argc,  char * argv[])
{
  struct rtnl_handle	rth;
  int opt;

  setlinebuf(stdout);
  /* Check command line options */
  while((opt = getopt_long(argc, argv, "hv", long_opts, NULL)) > 0)
    {
      switch(opt)
	{
	case 'h':
	  iw_usage(0);
	  break;

	case 'v':
	  return(iw_print_version_info("iwevent"));
	  break;

	default:
	  iw_usage(1);
	  break;
	}
    }
  if(optind < argc)
    {
      fputs("Too many arguments.\n", stderr);
      iw_usage(1);
    }

  /* Open netlink channel */
  if(rtnl_open(&rth, RTMGRP_LINK) < 0) 
    {
      perror("Can't initialize rtnetlink socket");
      return(1);
    }

  //Hongwei
  //set buffer size of the receiver link
  int size;
  int size_len = sizeof(size);
#ifdef DEBUG_FB_NUM
  getsockopt(rth.fd, SOL_SOCKET, SO_RCVBUF, &size, &size_len);
  printf("Existing netlink buffer size = %d\n", size);
#endif
  size = NET_LINK_RCV_BUF_SIZE;
  setsockopt(rth.fd, SOL_SOCKET, SO_RCVBUF, &size, sizeof(size));
  getsockopt(rth.fd, SOL_SOCKET, SO_RCVBUF, &size, &size_len);
  printf("Modified netlink rcv-buffer size = %d bytes\n", size);

#if WIRELESS_EXT > 13
  //Hongwei
  fprintf(stderr, "Waiting for TX_STATUS (TX, TXEXC) Events...\n");

  //create a channel to the NET kernel: get info. about NIC: bit rate ...
  if((skfd = iw_sockets_open()) < 0) {
    perror("socket: %m");
    exit(-1);
  }

  //create the UDP socket to linxy
  struct sockaddr_in sa = {
    sin_family: AF_INET,
    sin_port: htons(MAC_FEEDBACK_IWTX_UDP_PORT),
    sin_addr: {s_addr: INADDR_BROADCAST}
  };
  while ((sock_fd = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
    fprintf(stderr, "can't create socket: %m\n");
    //exit(-1);
    sleep(10);
  }
  //set the udp send buffer size
  long snd_buf_size = UDP_SEND_BUF_SIZE;
  int snd_size_len = sizeof(snd_buf_size);
  if (setsockopt(sock_fd, SOL_SOCKET, SO_SNDBUF, &snd_buf_size, sizeof(snd_buf_size)) < 0) 
    fprintf(stderr, "cannot set the UPD send buffer size to %f: %m\n", (double)snd_buf_size);
  else {
    getsockopt(sock_fd, SOL_SOCKET, SO_SNDBUF, &snd_buf_size, &snd_size_len);
    fprintf(stderr, "Modified UPD send-buffer size to linxyd = %f bytes\n", (double)snd_buf_size);
  }
  //set the socket as nonblocking ???no need to??? 
  int flags;
  if ((flags = fcntl(sock_fd, F_GETFL, 0)) >= 0) {
    flags |= O_NONBLOCK;
    fcntl(sock_fd, F_SETFL, flags);
  }
  //bind the socket to an interface
  while (bind(sock_fd, (struct sockaddr *) &sa, sizeof(sa)) < 0) {
    fprintf(stderr, "couldn't bind UDP socket to port %d: %m", MAC_FEEDBACK_IWTX_UDP_PORT);
    //exit(-1);
    sleep(10);
  }
  printf("iwtxstatus has set up the socket to report MAC feedback\n");
#else	/* WIRELESS_EXT > 13 */
  fprintf(stderr, "Unsupported in Wireless Extensions < 14 :-(\n");
  return(-1);
#endif	/* WIRELESS_EXT > 13 */

  /* Do what we have to do */
  wait_for_event(&rth);

  /* Cleanup - only if you are pedantic */
  rtnl_close(&rth);

  return(0);
}
