/***********************************************************************************
    Copyright (C) <2005>  <Hongwei Zhang>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    Author:
    =======
    Hongwei Zhang
    Department of Computer Science and Engineering
    The Ohio State University, USA

    E-mail: zhangho@cse.ohio-state.edu

***********************************************************************************/


 /*
 * linxy.h: type defintion for linxy.c
 *
 * Hongwei Zhang (zhangho@cis.ohio-state.edu)
 * Date: July 25, 2004 - 
 *
 */

//#include <sys/stat.h>
//#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h> 
#include <signal.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <linux/if_arp.h> //related to ARP cache

#include "emrun/emrun.h"
#include "link/link.h"

#include <libmisc/local_types.h>
#include "libmisc/misc.h"
#include "libdev/packet_dev.h"

#include "routing/exscal/uniComm/libmisc/misc_wlan_info.h"

#ifndef _LINK_PROXY_H
#define _LINK_PROXY_H

/* debug only */
//#define SIMULATION_ONLY 1   //comment OUT in real demo!!!!!
#define LX_DEBUG 1 //comment OUT in real demo
#define READ_MAC_TX_TIME 1  //to be commented out in real demo
#define LOG_LINK_STATS 1 //number of transmission & reception; to be commented out in real demo

//for stabilization
#define LX_TIMER_INTERVAL 30 //milliseconds
//for data buffer management, MAC feedback management, etc.
#define RECEIPT_TIMEOUT 60000 //milliseconds 
//for dealing with absence of mac feedback
#define DEFAULT_MAC_FB_DELAY 30 //milliseconds
#define MAX_MAC_FB_DELAY 90 //milliseconds
#define MAX_MAC_FB_LATENCY_RATIO 10 //compared to the existing average delay in getting feedback
#define MAX_ARP_RESOLUTION_DELAY 1000 //milliseconds
#define INTRA_NODE_ERROR_THRESHOLD_WAIT 30000 //milliseconds
#define MAX_OUTSTANDING_FB_WAIT 5

#define DEFAULT_LX_MTU 1500 //bytes 

#define UDP_RCV_BUF_SIZE 65535 //bytes; default is 40000
#define MAC_FEEDBACK_UDP_PORT  4960  //note: udpd uses 4950 (upd.c)
#define MAC_ADDR_DISPLAY_LEN  (2*6 + 5 + 1) //2*6: real addrss data    5: ':'    1:'\0'

#define INVALID_FB_MAC_ADDR_TRAIL "FF:FF:FF:FF" //the trail for broadcast packets only; and for
                                                                                                                      // fake feddback when destination un-reachable.

#define PKT_TYPE_LX_FB (PKT_TYPE_USER0 + 1) //used by clients for registration
#define PKT_TYPE_EXTRA_TX_FB (PKT_TYPE_USER0 + 2)  //a specil client_pkt_type: there have been duplicate TXes

#define PKT_TYPE_LX (PKT_TYPE_USER0 + 3)

typedef struct linxy_fb_pkt {
  link_pkt_type_t client_pkt_type;

  int status;   //1: success in sending       -1: failure in sending
                       //-2: no-mac-feedback because destination is down
                       //-3: UDPD fails to send, or some other intra-node issues
                       //-4: memory shortage to create buffer to wait for feedback
  //int retry;    //number of retries
  long fb_delay; //microseconds
  long bitrate; // bit/second
  struct timeval rcv_time;
  char mac_addr[MAC_ADDR_DISPLAY_LEN];
#ifdef LOG_LINK_STATS
  long tx_unicasts, tx_multicasts, rx_unicasts, rx_multicasts; 
#endif
} linxy_fb_pkt_t;

//The structure of the packets communicated between linxy and iwtxstatus
typedef struct linxy_iwtx_pkt {
  int status; //1: success              -1: failure
  long fb_delay; //microseconds
  long bitrate; // bit/second
  struct timeval rcv_time;
  char mac_addr[MAC_ADDR_DISPLAY_LEN];
} linxy_iwtx_pkt_t;

// The structure of the lx packet.
typedef struct lx_pkt {
  link_pkt_type_t client_pkt_type;   /*the packet type of the client/upper layer */
  uint8_t data[0];   	                    /* pointer to the data that follows */
} __attribute__ ((packed)) lx_pkt_t;

//An MAC feedback control buffer element
typedef struct linxy_error_control_buf {
  link_pkt_type_t pkt_type;
  if_id_t dest_id; //to detect whether it is for unicast or broadcast packet
  struct timeval send_time; //fb control

  //for FIFO feedback
  buf_t * up_pkt; //initialized to NULL, unless got a feedback and yet to be pushed up

  struct linxy_error_control_buf * next;
} lx_buf_t;

//data packets buffer
typedef struct linxy_data_buf {
  link_pkt_type_t pkt_type;
  buf_t * packet;

  struct linxy_data_buf * next;
} lx_data_buf_t; 

//the state of linxy
typedef struct lx_state {
  //for stabilization from fb "loss"
  uint16_t avg_fb_delay; //milliseconds; initialized to DEFAULT_MAC_FB_DELAY
  struct timeval last_send; 

  //data buffer
  lx_data_buf_t * data_buf_head, * data_buf_tail;
  int data_queue_len; //length of the data buffer queue; initialized to 0
  int writable; //initialized to 1, signifying lower layer is ready to accept new packets

  //receipt control
  g_event_t * receipt_timer;
  int receipt_waiting; //initialized to 0 (i.e., false)

  //Linxy control: head & tail of buffer space
  lx_buf_t * buf_head, * buf_tail; //to store info needed for composing feedback packets
  int outstanding_fb_wait; //initialized to 0
  int queue_len; //length of the buffer; initialized to 0
  pid_t child_process_id; //in which iwtxstatus runs
  int sock_fd; //the id of the socket to communicate with iwtxstatus

  //for stabilization: d/w permanent losss of feedback from iwtxstatus 
  //redundant to buf_head:  int is_waiting_ack;  //-1: not waiting     1: waiting
  long time_waited; //milliseconds; initialized to 0

  //for lu
  lu_context_t * link;	/* link connecting linxy to udp */

  //for lp
  lp_context_t * lp; 		/* handle to the link */ 
  char *dev_name;		/* name of the link to the application */
  link_status_t status;	/* status of the link */ 

#ifdef LX_DEBUG
  long num_sent; //initialized to 0
  long num_fb;  //initialized to 0
#endif
#ifdef LOG_LINK_STATS
  long tx_unicasts, tx_multicasts, rx_unicasts, rx_multicasts; //initialized to 0 
#endif
} lx_state_t;


/*functions defined in linxy_util.c */
lx_buf_t * allocate_mac_fb_buf( lx_state_t * r, link_pkt_type_t pkt_type, if_id_t dest_id);

int in_arp_cache_alive(if_id_t destination); //returns: 1 --> yes;     0--> no
void handle_fb_loss(lx_state_t * r);
void lx_send_error_fb(lx_state_t * r);
void lx_memory_shortage_fb(lx_state_t * r, lx_buf_t * fb_buf_ptr);
void lx_process_ack(lx_state_t * r, linxy_iwtx_pkt_t * fb_pkt,  lx_buf_t * fb_buf_ptr);

int receipt_timeout(void *data, int interval, g_event_t *ev);
int lx_handle_writable(lu_context_t * link); //callback funcation of writable
int lx_send_buffered_data_pkts(lx_state_t * r); 

#endif
