/* /proc routines for Host AP driver */

#define PROC_LIMIT (PAGE_SIZE - 80)

//Hongwei
//#define TX_RX_PROC_FILE "tx_rx" 
//#define DEBUG_MAC_FB_PROC_FILE "debug_fb"
//Hongwei: facilities to manipulate timeval variables (copied from UCLA Emstar)
/* Convert a timeval to microseconds as a long */
/*
long misc_tv_usec_l(struct timeval *t)
{
  return ((long) t->tv_sec * 1000000) + t->tv_usec;
}
*/
/* Hongwei:
 * convert long integers to strings
 * 
 * returns the starting position of the string.
 */
/*
char * ultoa(unsigned long, char* buf, int bufSize);
char * ltoa(long val, char * buf, int bufSize)
 {
     char *p;
     int flg = 0;
     if( val < 0 ) { 
       flg++;
       val= -val;
     }
     p = ultoa(val, buf, bufSize);
     if(flg) *--p = '-';
     return p;
 }
char * ultoa(unsigned long val, char* buf, int bufSize)
{
     char *p;
     
     p = buf+ bufSize;
     *--p = '\0';
     
     do {
          *--p = '0' + val%10;
          val/=10;
     } while(val);

     return p;
}
*/

/*
//Hongwei: put fb_delay into the proc fs file
static int fb_delay_read(char * page, char ** start, off_t off, int count, int * eof, void * data)
{
  int len;
  char buf[20];

  MOD_INC_USE_COUNT;

  //to guarantee that each read only reads once
  if (off != 0) {
    len= 0;
    *eof = 1;
  }
  else 
    //write the feedback delay as a string
    len = sprintf(page, "%s", ltoa(misc_tv_usec_l(&last_fb_delay), buf, sizeof(buf)));

  MOD_DEC_USE_COUNT;

  return len;
}
*/

/* Hongwei: 
 * 1) put the timestamp for the more recent packet send operation and reception operation
 * 2) present some wlan0 statistics
 */
/*
#ifdef TX_RX_PROC_FILE
static int tx_rx_read(char * page, char ** start, off_t off, int count, int * eof, void * data)
{
  int len;
  //char buf[20];
  //char buf2[20];

  //for wlan0 statistics
  local_info_t *local = (local_info_t *) data;
  struct comm_tallies_sums * sums = (struct comm_tallies_sums *)&local->comm_tallies;

  MOD_INC_USE_COUNT;

  //to guarantee that each read only reads once
  if (off != 0) {
    len= 0;
    *eof = 1;
  }
  else {
    //write the timestamp for the last send and reception operation; and wlan0 statistics
    len = sprintf(page, "%u   %u   %u   %u   %u   %u   %u   %u   %u   %u   %u   %u   %u   %u   %u   %u    %u  %u   %u   %u   %u",
		  (uint32_t)last_tx_time.tv_sec, (uint32_t)last_tx_time.tv_usec, 
		  (uint32_t)last_rx_time.tv_sec, (uint32_t)last_rx_time.tv_usec,
		  sums->tx_unicast_frames, sums->tx_multicast_frames, sums->tx_fragments, sums->tx_unicast_octets, sums->tx_multicast_octets, sums->tx_deferred_transmissions, sums->tx_single_retry_frames, sums->tx_multiple_retry_frames, sums->tx_retry_limit_exceeded, sums->tx_discards,  
		  sums->rx_unicast_frames, sums->rx_multicast_frames, sums->rx_fragments, sums->rx_unicast_octets, sums->rx_multicast_octets, sums->rx_fcs_errors, sums->rx_message_in_bad_msg_fragments 
	        );
  }

  MOD_DEC_USE_COUNT;

  return len;
}
#endif
*/


/*
//Hongwei: put fb_delay into the proc fs file
#ifdef DEBUG_MAC_FB_PROC_FILE
static int debug_fb_read(char * page, char ** start, off_t off, int count, int * eof, void * data)
{
  int len;

  MOD_INC_USE_COUNT;

  //to guarantee that each read only reads once
  if (off != 0) {
    len= 0;
    *eof = 1;
  }
  else 
    //write the feedback delay as a string
    len = sprintf(page, "hostap driver:  total_sent = %d    num_sent = %d    num_fb = %d\n", total_sent, num_sent, num_fb);

  MOD_DEC_USE_COUNT;

  return len;
}
#endif
*/

#ifndef PRISM2_NO_PROCFS_DEBUG
static int prism2_debug_proc_read(char *page, char **start, off_t off,
				  int count, int *eof, void *data)
{
	char *p = page;
	local_info_t *local = (local_info_t *) data;
	int i;

	if (off != 0) {
		*eof = 1;
		return 0;
	}

	p += sprintf(p, "next_txfid=%d next_alloc=%d\n",
		     local->next_txfid, local->next_alloc);
	for (i = 0; i < PRISM2_TXFID_COUNT; i++)
		p += sprintf(p, "FID: tx=%04X intransmit=%04X\n",
			     local->txfid[i], local->intransmitfid[i]);
	p += sprintf(p, "FW TX rate control: %d\n", local->fw_tx_rate_control);
	p += sprintf(p, "beacon_int=%d\n", local->beacon_int);
	p += sprintf(p, "dtim_period=%d\n", local->dtim_period);
	p += sprintf(p, "wds_max_connections=%d\n",
		     local->wds_max_connections);
	p += sprintf(p, "dev_enabled=%d\n", local->dev_enabled);
	p += sprintf(p, "sw_tick_stuck=%d\n", local->sw_tick_stuck);
	if (local->crypt && local->crypt->ops)
		p += sprintf(p, "crypt=%s\n", local->crypt->ops->name);
	p += sprintf(p, "pri_only=%d\n", local->pri_only);

	return (p - page);
}
#endif /* PRISM2_NO_PROCFS_DEBUG */


static int prism2_stats_proc_read(char *page, char **start, off_t off,
				  int count, int *eof, void *data)
{
	char *p = page;
	local_info_t *local = (local_info_t *) data;
	struct comm_tallies_sums *sums = (struct comm_tallies_sums *)
		&local->comm_tallies;

	if (off != 0) {
		*eof = 1;
		return 0;
	}

	p += sprintf(p, "TxUnicastFrames=%u\n", sums->tx_unicast_frames);
	p += sprintf(p, "TxMulticastframes=%u\n", sums->tx_multicast_frames);
	p += sprintf(p, "TxFragments=%u\n", sums->tx_fragments);
	p += sprintf(p, "TxUnicastOctets=%u\n", sums->tx_unicast_octets);
	p += sprintf(p, "TxMulticastOctets=%u\n", sums->tx_multicast_octets);
	p += sprintf(p, "TxDeferredTransmissions=%u\n",
		     sums->tx_deferred_transmissions);
	p += sprintf(p, "TxSingleRetryFrames=%u\n",
		     sums->tx_single_retry_frames);
	p += sprintf(p, "TxMultipleRetryFrames=%u\n",
		     sums->tx_multiple_retry_frames);
	p += sprintf(p, "TxRetryLimitExceeded=%u\n",
		     sums->tx_retry_limit_exceeded);
	p += sprintf(p, "TxDiscards=%u\n", sums->tx_discards);  
	p += sprintf(p, "RxUnicastFrames=%u\n", sums->rx_unicast_frames);
	p += sprintf(p, "RxMulticastFrames=%u\n", sums->rx_multicast_frames);
	p += sprintf(p, "RxFragments=%u\n", sums->rx_fragments);
	p += sprintf(p, "RxUnicastOctets=%u\n", sums->rx_unicast_octets);
	p += sprintf(p, "RxMulticastOctets=%u\n", sums->rx_multicast_octets);
	p += sprintf(p, "RxFCSErrors=%u\n", sums->rx_fcs_errors);
	p += sprintf(p, "RxDiscardsNoBuffer=%u\n",
		     sums->rx_discards_no_buffer);
	p += sprintf(p, "TxDiscardsWrongSA=%u\n", sums->tx_discards_wrong_sa);
	p += sprintf(p, "RxDiscardsWEPUndecryptable=%u\n",
		     sums->rx_discards_wep_undecryptable);
	p += sprintf(p, "RxMessageInMsgFragments=%u\n",
		     sums->rx_message_in_msg_fragments);
	p += sprintf(p, "RxMessageInBadMsgFragments=%u\n",
		     sums->rx_message_in_bad_msg_fragments);
	/* FIX: this may grow too long for one page(?) */

	return (p - page);
}


static int prism2_wds_proc_read(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	char *p = page;
	local_info_t *local = (local_info_t *) data;
	struct list_head *ptr;
	struct hostap_interface *iface;
	unsigned long flags;

	if (off > PROC_LIMIT) {
		*eof = 1;
		return 0;
	}

	read_lock_irqsave(&local->iface_lock, flags);
	list_for_each(ptr, &local->hostap_interfaces) {
		iface = list_entry(ptr, struct hostap_interface, list);
		if (iface->type != HOSTAP_INTERFACE_WDS)
			continue;
		p += sprintf(p, "%s\t" MACSTR "\n",
			     iface->dev->name,
			     MAC2STR(iface->u.wds.remote_addr));
		if ((p - page) > PROC_LIMIT) {
			printk(KERN_DEBUG "%s: wds proc did not fit\n",
			       local->dev->name);
			break;
		}
	}
	read_unlock_irqrestore(&local->iface_lock, flags);

	if ((p - page) <= off) {
		*eof = 1;
		return 0;
	}

	*start = page + off;

	return (p - page - off);
}


static int prism2_pda_proc_read(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	local_info_t *local = (local_info_t *) data;

	if (local->pda == NULL || off >= PRISM2_PDA_SIZE) {
		*eof = 1;
		return 0;
	}

	if (off + count > PRISM2_PDA_SIZE)
		count = PRISM2_PDA_SIZE - off;

	memcpy(page, local->pda + off, count);
	return count;
}


#ifdef PRISM2_IO_DEBUG
static int prism2_io_debug_proc_read(char *page, char **start, off_t off,
				     int count, int *eof, void *data)
{
	local_info_t *local = (local_info_t *) data;
	int head = local->io_debug_head;
	int start_bytes, left, copy, copied;

	if (off + count > PRISM2_IO_DEBUG_SIZE * 4) {
		*eof = 1;
		if (off >= PRISM2_IO_DEBUG_SIZE * 4)
			return 0;
		count = PRISM2_IO_DEBUG_SIZE * 4 - off;
	}

	copied = 0;
	start_bytes = (PRISM2_IO_DEBUG_SIZE - head) * 4;
	left = count;

	if (off < start_bytes) {
		copy = start_bytes - off;
		if (copy > count)
			copy = count;
		memcpy(page, ((u8 *) &local->io_debug[head]) + off, copy);
		left -= copy;
		if (left > 0)
			memcpy(&page[copy], local->io_debug, left);
	} else {
		memcpy(page, ((u8 *) local->io_debug) + (off - start_bytes),
		       left);
	}

	*start = page;

	return count;
}
#endif /* PRISM2_IO_DEBUG */


#ifndef PRISM2_NO_STATION_MODES
static int prism2_scan_results_proc_read(char *page, char **start, off_t off,
					 int count, int *eof, void *data)
{
	char *p = page;
	local_info_t *local = (local_info_t *) data;
	int entries, entry, i, len, total = 0, hostscan;
	struct hfa384x_scan_result *scanres;
	struct hfa384x_hostscan_result *hscanres;
	u8 *pos;

	p += sprintf(p, "CHID ANL SL BcnInt Capab Rate BSSID ATIM SupRates "
		     "SSID\n");

	spin_lock_bh(&local->lock);
	hostscan = local->last_scan_type == PRISM2_HOSTSCAN;
	entries = hostscan ? local->last_hostscan_results_count :
		local->last_scan_results_count;
	for (entry = 0; entry < entries; entry++) {
		hscanres = &local->last_hostscan_results[entry];
		scanres = &local->last_scan_results[entry];

		if (total + (p - page) <= off) {
			total += p - page;
			p = page;
		}
		if (total + (p - page) > off + count)
			break;
		if ((p - page) > (PAGE_SIZE - 200))
			break;

		if (hostscan) {
			p += sprintf(p, "%d %d %d %d 0x%02x %d " MACSTR " %d ",
				     le16_to_cpu(hscanres->chid),
				     (s16) le16_to_cpu(hscanres->anl),
				     (s16) le16_to_cpu(hscanres->sl),
				     le16_to_cpu(hscanres->beacon_interval),
				     le16_to_cpu(hscanres->capability),
				     le16_to_cpu(hscanres->rate),
				     MAC2STR(hscanres->bssid),
				     le16_to_cpu(hscanres->atim));
		} else {
			p += sprintf(p, "%d %d %d %d 0x%02x %d " MACSTR
				     " N/A ",
				     le16_to_cpu(scanres->chid),
				     (s16) le16_to_cpu(scanres->anl),
				     (s16) le16_to_cpu(scanres->sl),
				     le16_to_cpu(scanres->beacon_interval),
				     le16_to_cpu(scanres->capability),
				     le16_to_cpu(scanres->rate),
				     MAC2STR(scanres->bssid));
		}

		pos = hostscan ? hscanres->sup_rates : scanres->sup_rates;
		for (i = 0; i < sizeof(hscanres->sup_rates); i++) {
			if (pos[i] == 0)
				break;
			p += sprintf(p, "<%02x>", pos[i]);
		}
		p += sprintf(p, " ");

		pos = hostscan ? hscanres->ssid : scanres->ssid;
		len = le16_to_cpu(hostscan ? hscanres->ssid_len :
				  scanres->ssid_len);
		if (len > 32)
			len = 32;
		for (i = 0; i < len; i++) {
			unsigned char c = pos[i];
			if (c >= 32 && c < 127)
				p += sprintf(p, "%c", c);
			else
				p += sprintf(p, "<%02x>", c);
		}
		p += sprintf(p, "\n");
	}
	spin_unlock_bh(&local->lock);

	total += (p - page);
	if (total >= off + count)
		*eof = 1;

	if (total < off) {
		*eof = 1;
		return 0;
	}

	len = total - off;
	if (len > (p - page))
		len = p - page;
	*start = p - len;
	if (len > count)
		len = count;

	return len;
}
#endif /* PRISM2_NO_STATION_MODES */


void hostap_init_proc(local_info_t *local)
{
	local->proc = NULL;

	if (hostap_proc == NULL) {
		printk(KERN_WARNING "%s: hostap proc directory not created\n",
		       local->dev->name);
		return;
	}

	local->proc = proc_mkdir(local->dev->name, hostap_proc);
	if (local->proc == NULL) {
		printk(KERN_INFO "/proc/net/hostap/%s creation failed\n",
		       local->dev->name);
		return;
	}

#ifndef PRISM2_NO_PROCFS_DEBUG
	create_proc_read_entry("debug", 0, local->proc,
			       prism2_debug_proc_read, local);
#endif /* PRISM2_NO_PROCFS_DEBUG */
	//Hongwei
	/*
	create_proc_read_entry(MAC_LATENCY_PROC_FILE, 0, local->proc, fb_delay_read, local);
#ifdef TX_RX_PROC_FILE
	create_proc_read_entry(TX_RX_PROC_FILE, 0, local->proc, tx_rx_read, local);
#endif
#ifdef DEBUG_MAC_FB_PROC_FILE
	create_proc_read_entry(DEBUG_MAC_FB_PROC_FILE, 0, local->proc, debug_fb_read, local);
#endif
	*/
	create_proc_read_entry("stats", 0, local->proc,
			       prism2_stats_proc_read, local);
	create_proc_read_entry("wds", 0, local->proc,
			       prism2_wds_proc_read, local);
	create_proc_read_entry("pda", 0, local->proc,
			       prism2_pda_proc_read, local);
#ifdef PRISM2_IO_DEBUG
	create_proc_read_entry("io_debug", 0, local->proc,
			       prism2_io_debug_proc_read, local);
#endif /* PRISM2_IO_DEBUG */
#ifndef PRISM2_NO_STATION_MODES
	create_proc_read_entry("scan_results", 0, local->proc,
			       prism2_scan_results_proc_read, local);
#endif /* PRISM2_NO_STATION_MODES */
}


void hostap_remove_proc(local_info_t *local)
{
	if (local->proc != NULL) {
#ifndef PRISM2_NO_STATION_MODES
		remove_proc_entry("scan_results", local->proc);
#endif /* PRISM2_NO_STATION_MODES */
#ifdef PRISM2_IO_DEBUG
		remove_proc_entry("io_debug", local->proc);
#endif /* PRISM2_IO_DEBUG */
		//Hongwei
		/*
		remove_proc_entry(MAC_LATENCY_PROC_FILE, local->proc);
#ifdef TX_RX_PROC_FILE
		remove_proc_entry(TX_RX_PROC_FILE, local->proc);
#endif
#ifdef DEBUG_MAC_FB_PROC_FILE
		remove_proc_entry(DEBUG_MAC_FB_PROC_FILE, local->proc);
#endif
		*/
		remove_proc_entry("pda", local->proc);
		remove_proc_entry("wds", local->proc);
		remove_proc_entry("stats", local->proc);
#ifndef PRISM2_NO_PROCFS_DEBUG
		remove_proc_entry("debug", local->proc);
#endif /* PRISM2_NO_PROCFS_DEBUG */
		if (local->dev != NULL && local->dev->name != NULL &&
		    hostap_proc != NULL)
			remove_proc_entry(local->dev->name, hostap_proc);
	}
}


EXPORT_SYMBOL(hostap_init_proc);
EXPORT_SYMBOL(hostap_remove_proc);
